/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template.component;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.UnaryOperator;
import net.minecraft.util.text.ITextComponent;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.template.TemplateComponent;

public class ComponentHeader
extends TemplateComponent {
    public IVariable text;
    @SerializedName(value="color")
    public IVariable colorStr;
    boolean centered = true;
    float scale = 1.0f;
    transient ITextComponent actualText;
    transient int color;

    @Override
    public void build(BookPage page, BookEntry entry, int pageNum) {
        try {
            this.color = Integer.parseInt(this.colorStr.asString(""), 16);
        }
        catch (NumberFormatException e) {
            this.color = page.book.headerColor;
        }
        if (this.x == -1) {
            this.x = 58;
        }
        if (this.y == -1) {
            this.y = 0;
        }
    }

    @Override
    public void render(MatrixStack ms, BookPage page, int mouseX, int mouseY, float pticks) {
        ms.func_227860_a_();
        ms.func_227861_a_((double)this.x, (double)this.y, 0.0);
        ms.func_227862_a_(this.scale, this.scale, this.scale);
        if (this.centered) {
            page.parent.drawCenteredStringNoShadow(ms, page.i18n(this.actualText.getString()), 0, 0, this.color);
        } else {
            page.fontRenderer.func_238421_b_(ms, page.i18n(this.actualText.getString()), 0.0f, 0.0f, this.color);
        }
        ms.func_227865_b_();
    }

    @Override
    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        super.onVariablesAvailable(lookup);
        this.actualText = ((IVariable)lookup.apply(this.text)).as(ITextComponent.class);
        this.colorStr = (IVariable)lookup.apply(this.colorStr);
    }
}

