/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.TreeMultiset;
import com.google.common.collect.UnmodifiableIterator;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.InventoryHandler;
import cpw.mods.inventorysorter.InventorySorter;
import cpw.mods.inventorysorter.ItemStackHolder;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.util.Supplier;

public enum SortingHandler implements Consumer<ContainerContext>
{
    INSTANCE;

    private static final ResourceLocation DUMMY_PLAYER_CONTAINER;

    @Override
    public void accept(ContainerContext context) {
        if (context == null) {
            throw new NullPointerException("WHUT");
        }
        if (context.slotMapping == null) {
            return;
        }
        Multiset<ItemStackHolder> itemcounts = InventoryHandler.INSTANCE.getInventoryContent(context);
        if (context.slot.field_75224_c instanceof CraftingInventory) {
            this.distributeInventory(context, itemcounts);
        } else if (!context.slotMapping.markAsHeterogeneous) {
            this.compactInventory(context, itemcounts);
        }
    }

    private static ItemStack getStackInRowAndColumn(CraftingInventory inventory, int x, int y) {
        return inventory.func_70301_a(y * inventory.func_174922_i() + x);
    }

    private void distributeInventory(ContainerContext context, Multiset<ItemStackHolder> itemcounts) {
        ItemStackHolder ish;
        ItemStack is;
        int x;
        CraftingInventory ic = (CraftingInventory)context.slot.field_75224_c;
        TreeMultiset slotCounts = TreeMultiset.create((Comparator)new InventoryHandler.ItemStackComparator());
        for (int x2 = 0; x2 < ic.func_174922_i(); ++x2) {
            for (int y = 0; y < ic.func_174923_h(); ++y) {
                ItemStack is2 = SortingHandler.getStackInRowAndColumn(ic, x2, y);
                if (is2.func_190926_b()) continue;
                slotCounts.add((Object)new ItemStackHolder(is2));
            }
        }
        ImmutableMultiset staticcounts = ImmutableMultiset.copyOf(itemcounts);
        for (x = 0; x < ic.func_174922_i(); ++x) {
            for (int y = 0; y < ic.func_174923_h(); ++y) {
                is = SortingHandler.getStackInRowAndColumn(ic, x, y);
                if (is.func_190926_b()) continue;
                ish = new ItemStackHolder(is);
                int count = staticcounts.count((Object)ish);
                int slotNum = slotCounts.count((Object)ish);
                int occurrences = count / slotNum;
                itemcounts.remove((Object)ish, occurrences);
                is.func_190920_e(occurrences);
            }
        }
        for (x = 0; x < ic.func_174922_i(); ++x) {
            for (int y = 0; y < ic.func_174923_h(); ++y) {
                is = SortingHandler.getStackInRowAndColumn(ic, x, y);
                if (is.func_190926_b() || itemcounts.count((Object)(ish = new ItemStackHolder(is))) <= 0) continue;
                is.func_190917_f(itemcounts.setCount((Object)ish, 0));
            }
        }
        for (int slot = context.slotMapping.begin; slot < context.slotMapping.end + 1; ++slot) {
            context.player.field_71070_bA.func_75139_a(slot).func_75218_e();
        }
    }

    private void compactInventory(ContainerContext context, Multiset<ItemStackHolder> itemcounts) {
        UnmodifiableIterator itemsIterator;
        ResourceLocation containerTypeName;
        InventorySorter.INSTANCE.lastContainerType = containerTypeName = this.lookupContainerTypeName((Container)context.player.field_71069_bz);
        if (InventorySorter.INSTANCE.containerblacklist.contains(containerTypeName)) {
            InventorySorter.INSTANCE.debugLog("Container {} blacklisted", () -> new String[]{containerTypeName.toString()});
            return;
        }
        InventorySorter.INSTANCE.debugLog("Container \"{}\" being sorted", () -> new String[]{containerTypeName.toString()});
        try {
            itemsIterator = Multisets.copyHighestCountFirst(itemcounts).entrySet().iterator();
        }
        catch (Exception e) {
            InventorySorter.LOGGER.warn("Weird, the sorting didn't quite work!", (Throwable)e);
            return;
        }
        int slotLow = context.slotMapping.begin;
        int slotHigh = context.slotMapping.end + 1;
        Multiset.Entry stackHolder = itemsIterator.hasNext() ? (Multiset.Entry)itemsIterator.next() : null;
        int itemCount = stackHolder != null ? stackHolder.getCount() : 0;
        for (int i = slotLow; i < slotHigh; ++i) {
            Slot slot = context.player.field_71070_bA.func_75139_a(i);
            if (!slot.func_82869_a((PlayerEntity)context.player) && slot.func_75216_d()) {
                InventorySorter.LOGGER.log(Level.DEBUG, "Slot {} of container {} disallows canTakeStack", new Supplier[]{() -> slot.field_75222_d, () -> containerTypeName});
                continue;
            }
            slot.func_75215_d(ItemStack.field_190927_a);
            ItemStack target = ItemStack.field_190927_a;
            if (itemCount > 0 && stackHolder != null) {
                target = ((ItemStackHolder)stackHolder.getElement()).is.func_77946_l();
                target.func_190920_e(Math.min(itemCount, target.func_77976_d()));
            }
            if (!target.func_190926_b() && !slot.func_75214_a(target)) {
                ItemStack trg = target;
                InventorySorter.LOGGER.log(Level.DEBUG, "Item {} is not valid in slot {} of container {}", new Supplier[]{() -> trg, () -> slot.field_75222_d, () -> containerTypeName});
                continue;
            }
            slot.func_75215_d(target.func_190926_b() ? ItemStack.field_190927_a : target);
            if ((itemCount -= !target.func_190926_b() ? target.func_190916_E() : 0) != 0) continue;
            stackHolder = itemsIterator.hasNext() ? (Multiset.Entry)itemsIterator.next() : null;
            itemCount = stackHolder != null ? stackHolder.getCount() : 0;
        }
    }

    private ResourceLocation lookupContainerTypeName(Container container) {
        return container instanceof PlayerContainer ? DUMMY_PLAYER_CONTAINER : container.func_216957_a().getRegistryName();
    }

    static {
        DUMMY_PLAYER_CONTAINER = new ResourceLocation("inventorysorter:dummyplayercontainer");
    }
}

