/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.podium.tileentity;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import xyz.brassgoggledcoders.podium.api.PodiumAPI;
import xyz.brassgoggledcoders.podium.api.podium.IPodium;
import xyz.brassgoggledcoders.podium.api.podium.PodiumBehavior;
import xyz.brassgoggledcoders.podium.api.podium.PodiumInventory;
import xyz.brassgoggledcoders.podium.block.PodiumBlock;

public class PodiumTileEntity
extends TileEntity
implements IPodium {
    private final PodiumInventory podiumInventory = new PodiumInventory(ItemStack.field_190927_a, this::canPlayerUse);
    private PodiumBehavior podiumBehavior = null;

    public PodiumTileEntity(TileEntityType<? extends PodiumTileEntity> tileEntityType) {
        super(tileEntityType);
        this.podiumInventory.func_110134_a(this::inventoryListener);
    }

    public void inventoryListener(IInventory inventory) {
        if (!inventory.func_70301_a(0).func_190926_b()) {
            this.podiumBehavior = PodiumAPI.getPodiumBehavior(this, inventory.func_70301_a(0));
            this.setHasItem(true);
        } else {
            this.podiumBehavior = null;
            this.setHasItem(false);
        }
    }

    public ActionResultType activateBehavior(PlayerEntity playerEntity) {
        if (this.getPodiumBehavior() != null) {
            return this.getPodiumBehavior().activate(playerEntity);
        }
        return ActionResultType.PASS;
    }

    @ParametersAreNonnullByDefault
    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.setDisplayItemStack(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("displayItemStack")));
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_218657_a("displayItemStack", (INBT)this.getDisplayItemStack().func_77955_b(new CompoundNBT()));
        return nbt;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_218657_a("displayItemStack", (INBT)this.getDisplayItemStack().func_77955_b(new CompoundNBT()));
        return nbt;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.setDisplayItemStack(ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("displayItemStack")));
    }

    public ItemStack takeDisplayItemStack() {
        ItemStack itemStack = this.getDisplayItemStack();
        this.setDisplayItemStack(ItemStack.field_190927_a);
        return itemStack;
    }

    @Override
    public void setDisplayItemStack(@Nonnull ItemStack itemStack) {
        if (!itemStack.func_190926_b()) {
            this.podiumBehavior = PodiumAPI.getPodiumBehavior(this, itemStack);
            this.podiumInventory.func_70299_a(0, itemStack.func_77979_a(1));
            this.setHasItem(true);
        } else {
            this.podiumBehavior = null;
            this.podiumInventory.func_70299_a(0, ItemStack.field_190927_a);
            this.setHasItem(false);
        }
    }

    public void setHasItem(boolean hasItem) {
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)PodiumBlock.HAS_BOOK, (Comparable)Boolean.valueOf(hasItem)), 3);
        }
    }

    @Override
    public void pulseRedstone() {
        PodiumBlock.pulse(this.func_145831_w(), this.getPodiumPos(), this.getPodiumBlockState());
    }

    public int getComparatorSignal() {
        return this.getPodiumBehavior() != null ? this.getPodiumBehavior().getComparatorSignal() : 0;
    }

    @Override
    @Nonnull
    public PodiumInventory getPodiumInventory() {
        return this.podiumInventory;
    }

    @Override
    public void requestSave() {
        this.func_70296_d();
    }

    @Override
    @Nonnull
    public ItemStack getDisplayItemStack() {
        return this.podiumInventory.func_70301_a(0);
    }

    @Override
    @Nonnull
    public BlockPos getPodiumPos() {
        return this.func_174877_v();
    }

    @Override
    @Nonnull
    public BlockState getPodiumBlockState() {
        return this.func_195044_w();
    }

    @Override
    @Nonnull
    public IWorld getPodiumWorld() {
        return (IWorld)Objects.requireNonNull(this.func_145831_w());
    }

    @Nullable
    public PodiumBehavior getPodiumBehavior() {
        return this.podiumBehavior;
    }

    public boolean renderBook() {
        return this.getPodiumBehavior() != null && this.getPodiumBehavior().isBook();
    }

    public boolean canPlayerUse(PlayerEntity playerEntity) {
        return true;
    }
}

