/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.podium.podiumbehavior;

import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.LecternContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.brassgoggledcoders.podium.api.podium.IPodium;
import xyz.brassgoggledcoders.podium.api.podium.PodiumBehavior;
import xyz.brassgoggledcoders.podium.container.reference.SingleValueFunctionIntArray;

public class BookPodiumBehavior
extends PodiumBehavior {
    private final ToIntFunction<ItemStack> pageLength;
    private int page;

    public BookPodiumBehavior(IPodium podium, ToIntFunction<ItemStack> pageLength) {
        super(podium);
        this.pageLength = pageLength;
        this.page = 0;
    }

    @Override
    public ActionResultType activate(PlayerEntity playerEntity) {
        if (playerEntity instanceof ServerPlayerEntity) {
            playerEntity.func_213829_a((INamedContainerProvider)new LecternContainerProvider());
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public int getComparatorSignal() {
        int pages = this.pageLength.applyAsInt(this.getPodium().getDisplayItemStack());
        float f = pages > 1 ? (float)this.getPage() / ((float)pages - 1.0f) : 1.0f;
        return MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
    }

    private int getPage() {
        return this.page;
    }

    private void setPage(int pageIn) {
        int i = MathHelper.func_76125_a((int)pageIn, (int)0, (int)(this.pageLength.applyAsInt(this.getPodium().getDisplayItemStack()) - 1));
        if (i != this.page) {
            this.page = i;
            this.getPodium().requestSave();
            this.getPodium().pulseRedstone();
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74768_a("page", this.page);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.page = nbt.func_74762_e("page");
    }

    public class LecternContainerProvider
    implements INamedContainerProvider {
        @Nonnull
        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent("container.lectern");
        }

        @Nullable
        @ParametersAreNonnullByDefault
        public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
            return new LecternContainer(id, (IInventory)BookPodiumBehavior.super.getPodium().getPodiumInventory(), (IIntArray)new SingleValueFunctionIntArray(() -> BookPodiumBehavior.this.getPage(), x$0 -> BookPodiumBehavior.this.setPage(x$0)));
        }
    }
}

