/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.podium.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.brassgoggledcoders.podium.content.PodiumBlocks;
import xyz.brassgoggledcoders.podium.tileentity.PodiumTileEntity;

public class PodiumBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty HAS_BOOK = BlockStateProperties.field_222515_o;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape POST_SHAPE = Block.func_208617_a((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    public static final VoxelShape COMMON_SHAPE = VoxelShapes.func_197872_a((VoxelShape)BASE_SHAPE, (VoxelShape)POST_SHAPE);
    public static final VoxelShape TOP_PLATE_SHAPE = Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final VoxelShape COLLISION_SHAPE = VoxelShapes.func_197872_a((VoxelShape)COMMON_SHAPE, (VoxelShape)TOP_PLATE_SHAPE);
    public static final VoxelShape WEST_SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)1.0, (double)10.0, (double)0.0, (double)5.333333, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.333333, (double)12.0, (double)0.0, (double)9.666667, (double)16.0, (double)16.0), Block.func_208617_a((double)9.666667, (double)14.0, (double)0.0, (double)14.0, (double)18.0, (double)16.0), COMMON_SHAPE});
    public static final VoxelShape NORTH_SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)10.0, (double)1.0, (double)16.0, (double)14.0, (double)5.333333), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)12.0, (double)5.333333, (double)16.0, (double)16.0, (double)9.666667), Block.func_208617_a((double)0.0, (double)14.0, (double)9.666667, (double)16.0, (double)18.0, (double)14.0), COMMON_SHAPE});
    public static final VoxelShape EAST_SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)15.0, (double)10.0, (double)0.0, (double)10.666667, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)10.666667, (double)12.0, (double)0.0, (double)6.333333, (double)16.0, (double)16.0), Block.func_208617_a((double)6.333333, (double)14.0, (double)0.0, (double)2.0, (double)18.0, (double)16.0), COMMON_SHAPE});
    public static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)10.0, (double)15.0, (double)16.0, (double)14.0, (double)10.666667), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)12.0, (double)10.666667, (double)16.0, (double)16.0, (double)6.333333), Block.func_208617_a((double)0.0, (double)14.0, (double)6.333333, (double)16.0, (double)18.0, (double)2.0), COMMON_SHAPE});

    public PodiumBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)HAS_BOOK, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof PodiumTileEntity) {
            PodiumTileEntity podiumTileEntity = (PodiumTileEntity)tileEntity;
            ItemStack heldItem = player.func_184586_b(hand);
            if (!heldItem.func_190926_b() && podiumTileEntity.getDisplayItemStack().func_190926_b()) {
                podiumTileEntity.setDisplayItemStack(heldItem);
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HAS_BOOK, (Comparable)Boolean.valueOf(true)));
                return ActionResultType.SUCCESS;
            }
            if (player.func_225608_bj_()) {
                if (heldItem.func_190926_b()) {
                    player.func_184611_a(hand, podiumTileEntity.takeDisplayItemStack());
                    world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HAS_BOOK, (Comparable)Boolean.valueOf(false)));
                    return ActionResultType.SUCCESS;
                }
            } else {
                return podiumTileEntity.activateBehavior(player);
            }
        }
        return ActionResultType.PASS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PodiumTileEntity(PodiumBlocks.PODIUM_TILE_ENTITY.get());
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        return COMMON_SHAPE;
    }

    @Nonnull
    public BlockState func_196258_a(BlockItemUseContext context) {
        CompoundNBT blockEntityTag;
        World world = context.func_195991_k();
        ItemStack itemstack = context.func_195996_i();
        CompoundNBT compoundnbt = itemstack.func_77978_p();
        PlayerEntity playerentity = context.func_195999_j();
        boolean flag = false;
        if (!world.field_72995_K && playerentity != null && compoundnbt != null && playerentity.func_195070_dx() && compoundnbt.func_74764_b("BlockEntityTag") && (blockEntityTag = compoundnbt.func_74775_l("BlockEntityTag")).func_74764_b("displayItemStack")) {
            flag = true;
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)HAS_BOOK, (Comparable)Boolean.valueOf(flag));
    }

    public boolean func_149740_M(@Nonnull BlockState state) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof PodiumTileEntity) {
            return ((PodiumTileEntity)tileEntity).getComparatorSignal();
        }
        return 0;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return COLLISION_SHAPE;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return COMMON_SHAPE;
    }

    @Nonnull
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, HAS_BOOK, POWERED});
    }

    @ParametersAreNonnullByDefault
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            if (((Boolean)state.func_177229_b((Property)HAS_BOOK)).booleanValue()) {
                this.dropBook(state, world, pos);
            }
            if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
                world.func_195593_d(pos.func_177977_b(), (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_196266_a(BlockState state, IBlockReader blockReader, BlockPos pos, PathType type) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void func_225534_a_(BlockState blockState, ServerWorld world, BlockPos pos, Random rand) {
        PodiumBlock.setPowered((World)world, pos, blockState, false);
    }

    @ParametersAreNonnullByDefault
    public boolean func_149744_f(BlockState blockState) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public int func_180656_a(BlockState blockState, IBlockReader blockReader, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((Property)POWERED) != false ? 15 : 0;
    }

    @ParametersAreNonnullByDefault
    public int func_176211_b(BlockState blockState, IBlockReader blockReader, BlockPos pos, Direction side) {
        return side == Direction.UP && (Boolean)blockState.func_177229_b((Property)POWERED) != false ? 15 : 0;
    }

    public static void pulse(World worldIn, BlockPos pos, BlockState state) {
        PodiumBlock.setPowered(worldIn, pos, state, true);
        worldIn.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 2);
        worldIn.func_217379_c(1043, pos, 0);
    }

    private static void setPowered(World world, BlockPos pos, BlockState blockState, boolean powered) {
        world.func_180501_a(pos, (BlockState)blockState.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        PodiumBlock.notifyNeighbors(world, pos, blockState);
    }

    private static void notifyNeighbors(World world, BlockPos pos, BlockState blockState) {
        world.func_195593_d(pos.func_177977_b(), blockState.func_177230_c());
    }

    private void dropBook(BlockState state, World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof PodiumTileEntity) {
            PodiumTileEntity podiumTileEntity = (PodiumTileEntity)tileentity;
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            ItemStack itemstack = podiumTileEntity.takeDisplayItemStack();
            float f = 0.25f * (float)direction.func_82601_c();
            float f1 = 0.25f * (float)direction.func_82599_e();
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5 + (double)f, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5 + (double)f1, itemstack);
            itemEntity.func_174869_p();
            world.func_217376_c((Entity)itemEntity);
        }
    }
}

