/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.podium.api.bookholder;

import java.lang.ref.WeakReference;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.brassgoggledcoders.podium.api.PodiumAPI;
import xyz.brassgoggledcoders.podium.api.bookholder.IBookHolder;
import xyz.brassgoggledcoders.podium.api.event.GetPageContentsEvent;

public class LecternBookHolder
implements IBookHolder {
    private final WeakReference<LecternTileEntity> lectern;
    private boolean gettingContents = false;
    private int lastOpenPage = -1;
    private String pageContents = null;

    public LecternBookHolder(LecternTileEntity lectern) {
        this.lectern = new WeakReference<LecternTileEntity>(lectern);
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return Optional.ofNullable(this.lectern.get()).map(LecternTileEntity::func_214033_c).orElse(ItemStack.field_190927_a);
    }

    @Override
    @Nullable
    public String getOpenPage() {
        return this.getLecternPage() + "";
    }

    private int getLecternPage() {
        return Optional.ofNullable(this.lectern.get()).map(LecternTileEntity::func_214041_g).orElse(0);
    }

    @Override
    @Nullable
    public String getPageContents() {
        if (this.pageContents == null || this.lastOpenPage != this.getLecternPage()) {
            this.lastOpenPage = this.getLecternPage();
            if (!this.gettingContents) {
                this.gettingContents = true;
                GetPageContentsEvent getPageContentsEvent = new GetPageContentsEvent(this);
                MinecraftForge.EVENT_BUS.post((Event)getPageContentsEvent);
                this.gettingContents = false;
                this.pageContents = getPageContentsEvent.getPageContent();
            } else {
                PodiumAPI.LOGGER.error("Called 'getPageContents' from 'BookContentsEvent'");
            }
        }
        return this.pageContents;
    }
}

