/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.provider.deserializers.value;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.valkyrieofnight.vlib.core.io.json.JsonUtils;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.modloader.util.RegistryUtils;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializer;
import com.valkyrieofnight.vlib.registry.provider.value.RawValueProvider;
import java.lang.reflect.Type;
import java.util.Optional;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;

public class RawValueProviderDeserializers {
    public static final String TYPE = "raw";
    private static final boolean debug = false;
    public static final ProviderDeserializer<RawValueProvider.Boolean> BOOLEAN = new ProviderDeserializer<RawValueProvider.Boolean>(RawValueProvider.Boolean.class, "raw:boolean"){

        public RawValueProvider.Boolean deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    boolean val = JsonUtils.getAsBoolean(jo, this.getTypeIdentifier());
                    return new RawValueProvider.Boolean(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.Byte> BYTE = new ProviderDeserializer<RawValueProvider.Byte>(RawValueProvider.Byte.class, "raw:byte"){

        public RawValueProvider.Byte deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    byte val = JsonUtils.getAsByte(jo, this.getTypeIdentifier());
                    return new RawValueProvider.Byte(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.Short> SHORT = new ProviderDeserializer<RawValueProvider.Short>(RawValueProvider.Short.class, "raw:short"){

        public RawValueProvider.Short deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    short val = JsonUtils.getAsShort(jo, this.getTypeIdentifier());
                    return new RawValueProvider.Short(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.Int> INT = new ProviderDeserializer<RawValueProvider.Int>(RawValueProvider.Int.class, "raw:int"){

        public RawValueProvider.Int deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    int val = JsonUtils.getAsInt(jo, this.getTypeIdentifier());
                    return new RawValueProvider.Int(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.Long> LONG = new ProviderDeserializer<RawValueProvider.Long>(RawValueProvider.Long.class, "raw:long"){

        public RawValueProvider.Long deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    long val = JsonUtils.getAsLong(jo, this.getTypeIdentifier());
                    return new RawValueProvider.Long(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.Float> FLOAT = new ProviderDeserializer<RawValueProvider.Float>(RawValueProvider.Float.class, "raw:float"){

        public RawValueProvider.Float deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    float val = JsonUtils.getAsFloat(jo, this.getTypeIdentifier());
                    return new RawValueProvider.Float(Float.valueOf(val));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.Double> DOUBLE = new ProviderDeserializer<RawValueProvider.Double>(RawValueProvider.Double.class, "raw:double"){

        public RawValueProvider.Double deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    double val = JsonUtils.getAsDouble(jo, this.getTypeIdentifier());
                    return new RawValueProvider.Double(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.Char> CHAR = new ProviderDeserializer<RawValueProvider.Char>(RawValueProvider.Char.class, "raw:char"){

        public RawValueProvider.Char deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    char val = JsonUtils.getAsChar(jo, this.getTypeIdentifier());
                    return new RawValueProvider.Char(Character.valueOf(val));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.String> STRING = new ProviderDeserializer<RawValueProvider.String>(RawValueProvider.String.class, "raw:string"){

        public RawValueProvider.String deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    String val = JsonUtils.getAsString(jo, this.getTypeIdentifier());
                    return new RawValueProvider.String(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.Item> ITEM = new ProviderDeserializer<RawValueProvider.Item>(RawValueProvider.Item.class, "raw:item"){

        public RawValueProvider.Item deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    String val = JsonUtils.getAsString(jo, this.getTypeIdentifier());
                    Optional<Item> item = com.valkyrieofnight.vlib.core.util.game.RegistryUtils.getOptionalItemFromID(VLID.from(val));
                    if (item.isPresent()) {
                        return new RawValueProvider.Item(item.get());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.Fluid> FLUID = new ProviderDeserializer<RawValueProvider.Fluid>(RawValueProvider.Fluid.class, "raw:fluid"){

        public RawValueProvider.Fluid deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    String val = JsonUtils.getAsString(jo, this.getTypeIdentifier());
                    Optional<Fluid> fluid = com.valkyrieofnight.vlib.core.util.game.RegistryUtils.getOptionalFluidFromID(VLID.from(val));
                    if (fluid.isPresent() && fluid.get() != Fluids.field_204541_a) {
                        return new RawValueProvider.Fluid(fluid.get());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.CompoundNBT> COMPOUND_NBT = new ProviderDeserializer<RawValueProvider.CompoundNBT>(RawValueProvider.CompoundNBT.class, "raw:nbt"){

        public RawValueProvider.CompoundNBT deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    String val = JsonUtils.getAsString(jo, this.getTypeIdentifier());
                    CompoundNBT nbt = JsonToNBT.func_180713_a((String)val);
                    return new RawValueProvider.CompoundNBT(nbt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.ItemTag> ITEM_TAG = new ProviderDeserializer<RawValueProvider.ItemTag>(RawValueProvider.ItemTag.class, "raw:item_tag"){

        public RawValueProvider.ItemTag deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    String value = JsonUtils.getAsString(jo, this.getTypeIdentifier());
                    return new RawValueProvider.ItemTag(VLID.from(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.BlockTag> BLOCK_TAG = new ProviderDeserializer<RawValueProvider.BlockTag>(RawValueProvider.BlockTag.class, "raw:block_tag"){

        public RawValueProvider.BlockTag deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    String value = JsonUtils.getAsString(jo, this.getTypeIdentifier());
                    return new RawValueProvider.BlockTag(VLID.from(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.FluidTag> FLUID_TAG = new ProviderDeserializer<RawValueProvider.FluidTag>(RawValueProvider.FluidTag.class, "raw:fluid_tag"){

        public RawValueProvider.FluidTag deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    String value = JsonUtils.getAsString(jo, this.getTypeIdentifier());
                    return new RawValueProvider.FluidTag(VLID.from(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.ItemStack> ITEMSTACK = new ProviderDeserializer<RawValueProvider.ItemStack>(RawValueProvider.ItemStack.class, "raw:itemstack"){

        public RawValueProvider.ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    CompoundNBT tag;
                    String item = JsonUtils.getAsString(jo, this.getTypeIdentifier());
                    Optional<Item> itemOptional = RegistryUtils.getItem(item);
                    int stackSize = JsonUtils.getAsIntOrDefault(jo, "count", 1);
                    String nbt = JsonUtils.getAsStringOrDefault(jo, "nbt", "");
                    CompoundNBT compoundNBT = tag = !StringUtils.isNullOrEmpty(nbt) ? JsonToNBT.func_180713_a((String)nbt) : null;
                    if (itemOptional.isPresent()) {
                        if (itemOptional.get() == Items.field_190931_a) {
                            return null;
                        }
                        ItemStack is = new ItemStack((IItemProvider)itemOptional.get(), stackSize);
                        is.func_77982_d(tag);
                        return new RawValueProvider.ItemStack(is);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<RawValueProvider.FluidStack> FLUIDSTACK = new ProviderDeserializer<RawValueProvider.FluidStack>(RawValueProvider.FluidStack.class, "raw:fluidstack"){

        public RawValueProvider.FluidStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    String fluid = JsonUtils.getAsString(jo, this.getTypeIdentifier());
                    Optional<Fluid> fluidOptional = RegistryUtils.getFluid(fluid);
                    int amount = JsonUtils.getAsIntOrDefault(jo, "amount", 1);
                    String nbt = JsonUtils.getAsString(jo, "nbt");
                    CompoundNBT tag = JsonToNBT.func_180713_a((String)nbt);
                    if (fluidOptional.isPresent()) {
                        FluidStack fs = new FluidStack(fluidOptional.get(), amount);
                        fs.setTag(tag);
                        return new RawValueProvider.FluidStack(fs);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    };
}

