/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.conditiondata.base;

import com.valkyrieofnight.vlib.core.util.logic.operators.RelationalOperator;
import com.valkyrieofnight.vlib.registry.conditiondata.base.ConditionParameters;

public enum ConditionType {
    BOOLEAN("boolean", new RelationalOperator[]{RelationalOperator.EQUAL, RelationalOperator.NOT_EQUAL}, new ConditionParameters[]{ConditionParameters.DEFAULT}),
    BYTE("byte", RelationalOperator.getAll(), ConditionParameters.getAll()),
    SHORT("short", RelationalOperator.getAll(), ConditionParameters.getAll()),
    INT("int", RelationalOperator.getAll(), ConditionParameters.getAll()),
    LONG("long", RelationalOperator.getAll(), ConditionParameters.getAll()),
    FLOAT("float", RelationalOperator.getAll(), ConditionParameters.getAll()),
    DOUBLE("double", RelationalOperator.getAll(), ConditionParameters.getAll()),
    CHAR("char", new RelationalOperator[]{RelationalOperator.EQUAL, RelationalOperator.NOT_EQUAL}, new ConditionParameters[]{ConditionParameters.DEFAULT}),
    STRING("string", new RelationalOperator[]{RelationalOperator.EQUAL, RelationalOperator.NOT_EQUAL}, new ConditionParameters[]{ConditionParameters.DEFAULT}),
    INVALID("", new RelationalOperator[0], new ConditionParameters[0]);

    private final String name;
    private final RelationalOperator[] operators;
    private final ConditionParameters[] parameters;
    private static ConditionType[] ALL;

    private ConditionType(String name, RelationalOperator[] operators, ConditionParameters[] parameters) {
        this.name = name;
        this.operators = operators;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public RelationalOperator[] getOperators() {
        return this.operators;
    }

    public ConditionParameters[] getParameters() {
        return this.parameters;
    }

    public static ConditionType[] getAll() {
        return ALL;
    }

    public static ConditionType getFromName(String name) {
        for (ConditionType t : ALL) {
            if (!t.name.equals(name)) continue;
            return t;
        }
        return INVALID;
    }

    static {
        ALL = ConditionType.values();
    }
}

