/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.autoutil;

import com.valkyrieofnight.vlib.core.util.StyleUtil;
import com.valkyrieofnight.vlib.core.util.WorldUtils;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.convenience.ITick;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.multiblock.Structure;
import com.valkyrieofnight.vlib.multiblock.component.Component;
import com.valkyrieofnight.vlib.multiblock.component.ComponentLayoutList;
import com.valkyrieofnight.vlib.multiblock.obj.tile.IController;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractAuto<TILE extends TileEntity>
implements ITick {
    protected final TILE controller;
    protected final PlayerEntity player;
    protected final Structure structure;
    protected final ServerWorld world;
    protected final XYZOrientation orientation;
    private final boolean requeue;
    private boolean running = true;
    private final int speed;
    private volatile BlockingQueue<CompPos> offsetQueue;
    private volatile Action onFinishedAction;

    public AbstractAuto(ServerWorld world, TILE controller, PlayerEntity player, XYZOrientation orientation, int speed, boolean requeue) {
        this.controller = controller;
        this.player = player;
        this.structure = ((IController)this.controller).getStructure();
        this.orientation = orientation;
        this.speed = speed;
        this.world = world;
        this.requeue = requeue;
        this.setup();
    }

    public AbstractAuto(ServerWorld world, TILE controller, PlayerEntity player, XYZOrientation orientation, int speed) {
        this(world, controller, player, orientation, speed, true);
    }

    public AbstractAuto(ServerWorld world, TILE controller, PlayerEntity player, XYZOrientation orientation, int speed, Action finishedAction) {
        this(world, controller, player, orientation, speed, true);
        this.onFinishedAction = finishedAction;
    }

    public AbstractAuto(ServerWorld world, TILE controller, PlayerEntity player, XYZOrientation orientation, int speed, Action finishedAction, boolean requeue) {
        this(world, controller, player, orientation, speed, requeue);
        this.onFinishedAction = finishedAction;
    }

    private void setup() {
        if (this.orientation == null || !this.structure.isValidOrientation(this.orientation)) {
            this.player.func_145747_a((ITextComponent)new TranslationTextComponent("status.valkyrielib.invaliddirection").func_230530_a_(StyleUtil.create(Color4.RED)), Util.field_240973_b_);
            this.player.func_145747_a((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)new TranslationTextComponent("status.valkyrielib.invaliddirectionsuggestion")).func_230530_a_(StyleUtil.create(Color4.DARK_GREEN)), Util.field_240973_b_);
            this.running = false;
            return;
        }
        this.offsetQueue = new ArrayBlockingQueue<CompPos>(this.structure.getTotalBlocks());
        Set<Component> comps = this.structure.getComponents();
        for (Component comp : comps) {
            ComponentLayoutList cll = this.structure.getLayoutList(comp);
            Collection<BlockPos> pos = cll.getAllRotated(((IController)this.controller).getPosition(), this.orientation);
            pos.forEach(bp -> this.offsetQueue.add(new CompPos(comp, (BlockPos)bp)));
        }
    }

    @Override
    public synchronized void tick() {
        if (this.offsetQueue.isEmpty()) {
            this.finished();
            return;
        }
        if (!this.player.func_70089_S()) {
            this.running = false;
            return;
        }
        for (int i = 0; i < this.speed; ++i) {
            if (this.offsetQueue.isEmpty()) {
                this.finished();
                return;
            }
            CompPos cp = (CompPos)this.offsetQueue.poll();
            if (!this.world.isAreaLoaded(cp.offset, 1)) {
                this.player.func_146105_b((ITextComponent)new StringTextComponent("Skipping block at: " + cp.offset.toString() + " because not in loaded area."), false);
            }
            if (this.doWork(cp) || !this.requeue) continue;
            this.reQueuePos(cp);
        }
    }

    protected void finished() {
        this.onFinished();
        this.running = false;
        if (this.onFinishedAction != null) {
            this.onFinishedAction.execute();
        }
    }

    protected abstract void onFinished();

    protected abstract boolean doWork(CompPos var1);

    protected void reQueuePos(CompPos cp) {
        this.offsetQueue.add(cp);
    }

    protected boolean isBlockClear(BlockPos pos) {
        return this.world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refundItem(ItemStack s) {
        if (this.player.field_71075_bZ.field_75098_d) {
            return;
        }
        PlayerInventory playerInventory = this.player.field_71071_by;
        synchronized (playerInventory) {
            for (ItemStack is : this.player.field_71071_by.field_70462_a) {
                if (!is.func_77969_a(s) || is.func_190916_E() + s.func_190916_E() > is.func_77976_d()) continue;
                is.func_190920_e(is.func_190916_E() + s.func_190916_E());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ItemStack consumeItem(CompPos compPos) {
        PlayerInventory playerInventory = this.player.field_71071_by;
        synchronized (playerInventory) {
            for (ItemStack s : this.player.field_71071_by.field_70462_a) {
                if (!compPos.component.isValid(s)) continue;
                return this.player.field_71075_bZ.field_75098_d ? s.func_77946_l() : s.func_77979_a(1);
            }
        }
        return ItemStack.field_190927_a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ItemStack copyFirst(CompPos compPos) {
        PlayerInventory playerInventory = this.player.field_71071_by;
        synchronized (playerInventory) {
            for (ItemStack s : this.player.field_71071_by.field_70462_a) {
                if (!compPos.component.isValid(s)) continue;
                return s.func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasItem(CompPos compPos) {
        if (this.player.field_71075_bZ.field_75098_d) {
            return true;
        }
        PlayerInventory playerInventory = this.player.field_71071_by;
        synchronized (playerInventory) {
            for (ItemStack s : this.player.field_71071_by.field_70462_a) {
                if (!compPos.component.isValid(s)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean placeBlock(CompPos compPos, ItemStack stack) {
        return WorldUtils.placeBlock((World)this.world, compPos.offset, stack, true);
    }

    public boolean isRunning() {
        return this.running;
    }

    protected static class CompPos {
        public final Component component;
        public final BlockPos offset;

        public CompPos(Component component, BlockPos offset) {
            this.component = component;
            this.offset = offset;
        }
    }
}

