/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.modifier;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.valkyrieofnight.vlib.modifier.AbstractModifierHandler;
import com.valkyrieofnight.vlib.modifier.IModifierTile;
import com.valkyrieofnight.vlib.modifier.attribute.Attribute;
import com.valkyrieofnight.vlib.modifier.attribute.AttributeID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileModifierHandler
extends AbstractModifierHandler {
    private TileEntity tile;
    protected Collection<BlockPos> modifiers = Lists.newArrayList();
    protected final int scanRate;
    protected Queue<BlockPos> queue = Queues.newArrayDeque();
    protected Map<Attribute, List<Object>> values = Maps.newHashMap();

    public TileModifierHandler(TileEntity tile) {
        this(tile, 3);
    }

    public TileModifierHandler(TileEntity tile, int scanRate) {
        this.tile = tile;
        this.scanRate = scanRate;
    }

    @Override
    public void scanAttributes() {
        this.processUnScanned();
        if (this.queue.isEmpty()) {
            this.finalCalculate();
        }
    }

    private void processUnScanned() {
        World w = this.tile.func_145831_w();
        for (int i = 0; i < this.scanRate && !this.queue.isEmpty(); ++i) {
            CompoundNBT nbt;
            BlockPos pos = this.queue.poll();
            TileEntity te = w.func_175625_s(pos);
            if (!(te instanceof IModifierTile) || (nbt = ((IModifierTile)te).getAttributeTag()) == null || nbt.isEmpty()) continue;
            for (Attribute atr : this.scannable) {
                Object o;
                if (!atr.hasAttribute(nbt) || (o = atr.readFromNBT(nbt)) == null) continue;
                this.values.computeIfPresent(atr, (k, v) -> {
                    v.add(o);
                    return v;
                });
            }
        }
    }

    private void finalCalculate() {
        for (Attribute a : this.values.keySet()) {
            Object f = a.getFinalized(this.values.get(a));
            this.finalizedValues.put(a.getID(), f);
        }
        this.resetQueue();
    }

    private void resetQueue() {
        this.queue.clear();
        this.queue.addAll(this.modifiers);
        this.values = Maps.newHashMap();
        for (Attribute a : this.scannable) {
            this.values.put(a, new ArrayList());
        }
    }

    public void setScannable(Collection<BlockPos> modifiers) {
        this.modifiers = modifiers;
        this.resetQueue();
    }

    public Object getFinalValue(AttributeID id) {
        if (this.finalizedValues.containsKey(id)) {
            return this.finalizedValues.get(id);
        }
        return null;
    }

    @Override
    public String toString() {
        return "TileModifierHandler{super:" + super.toString() + ", tile=" + this.tile + ", modifiers=" + this.modifiers + ", scanRate=" + this.scanRate + ", queue=" + this.queue + ", values=" + this.values + '}';
    }
}

