/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.wrapped;

import com.valkyrieofnight.vlib.core.obj.block.base.IProvideBlockProps;
import com.valkyrieofnight.vlib.core.obj.block.base.IProvideCustomItemBlock;
import com.valkyrieofnight.vlib.core.obj.item.VLBlockItem;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeID;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeRegistry;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.module.registry.IMCRegistry;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.stats.StatType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.blockplacer.BlockPlacerType;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.IRuleTestType;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;

public abstract class VLRegistry
implements IMCRegistry {
    protected final IMCRegistry REG;

    public VLRegistry(IMCRegistry reg) {
        this.REG = reg;
    }

    @Override
    public void registerBlock(@NotNull Block block) {
        if (block == null) {
            throw new RuntimeException("Tried registering null block");
        }
        this.REG.registerBlock(block);
        if (block instanceof IProvideCustomItemBlock) {
            this.registerItem((Item)((IProvideCustomItemBlock)block).getCustomBlockItem(block));
        } else {
            VLBlockItem bi;
            if (block instanceof IProvideBlockProps) {
                bi = new VLBlockItem(block, ((IProvideBlockProps)block).getBlockProps());
            } else {
                bi = new BlockItem(block, new Item.Properties());
                bi.setRegistryName(block.getRegistryName());
            }
            this.registerItem((Item)bi);
        }
    }

    @Override
    public void registerTileType(@NotNull TileEntityType<?> tile) {
        if (tile == null) {
            throw new RuntimeException("Tried registering null TileType");
        }
        this.REG.registerTileType(tile);
    }

    @Override
    public void registerItem(@NotNull Item item) {
        if (item == null) {
            throw new RuntimeException("Tried registering null Item");
        }
        this.REG.registerItem(item);
    }

    @Override
    public void registerFluid(@NotNull Fluid fluid) {
        if (fluid == null) {
            throw new RuntimeException("Tried registering null Fluid");
        }
        this.REG.registerFluid(fluid);
    }

    @Override
    public void registerEntityType(@NotNull EntityType<?> entity) {
        if (entity == null) {
            throw new RuntimeException("Tried registering null EntityType");
        }
        this.REG.registerEntityType(entity);
    }

    @Override
    public void registerPotion(@NotNull Potion potion) {
        if (potion == null) {
            throw new RuntimeException("Tried registering null Potion");
        }
        this.REG.registerPotion(potion);
    }

    @Override
    public void registerDimensionType(@NotNull DimensionType dimension) {
        if (dimension == null) {
            throw new RuntimeException("Tried registering null DimensionType");
        }
        this.REG.registerDimensionType(dimension);
    }

    @Override
    public void registerEffect(@NotNull Effect effect) {
        if (effect == null) {
            throw new RuntimeException("Tried registering null Effect");
        }
        this.REG.registerEffect(effect);
    }

    @Override
    public void registerEnchantment(@NotNull Enchantment enchant) {
        if (enchant == null) {
            throw new RuntimeException("Tried registering null Enchantment");
        }
        this.REG.registerEnchantment(enchant);
    }

    @Override
    public void registerContainerType(@NotNull ContainerType<?> container) {
        if (container == null) {
            throw new RuntimeException("Tried registering null ContainerType");
        }
        this.REG.registerContainerType(container);
    }

    @Override
    public void registerRecipeType(@NotNull IRecipeType<?> recipeType) {
        if (recipeType == null) {
            throw new RuntimeException("Tried registering null IRecipeType");
        }
        this.REG.registerRecipeType(recipeType);
    }

    @Override
    public void registerRecipeSerializer(@NotNull IRecipeSerializer<?> recipeSerializer) {
        if (recipeSerializer == null) {
            throw new RuntimeException("Tried registering null IRecipeSerializer");
        }
        this.REG.registerRecipeSerializer(recipeSerializer);
    }

    @Override
    public void registerReloadListener(@NotNull IFutureReloadListener listener) {
        if (listener == null) {
            throw new RuntimeException("Tried registering null IReloadListener");
        }
        this.REG.registerReloadListener(listener);
    }

    @Override
    public void registerWorldCarver(@NotNull WorldCarver<?> carver) {
        if (carver == null) {
            throw new RuntimeException("Tried registering null WorldCarver");
        }
        this.REG.registerWorldCarver(carver);
    }

    @Override
    public void registerSurfaceBuilder(@NotNull SurfaceBuilder<?> surfaceBuilder) {
        if (surfaceBuilder == null) {
            throw new RuntimeException("Tried registering null SurfaceBuilder");
        }
        this.REG.registerSurfaceBuilder(surfaceBuilder);
    }

    @Override
    public void registerFeature(@NotNull Feature<?> feature) {
        if (feature == null) {
            throw new RuntimeException("Tried registering null Feature");
        }
        this.REG.registerFeature(feature);
    }

    @Override
    public void registerPlacement(@NotNull Placement<?> decorator) {
        if (decorator == null) {
            throw new RuntimeException("Tried registering null Placement");
        }
        this.REG.registerPlacement(decorator);
    }

    @Override
    public void registerBiome(@NotNull Biome biome) {
        if (biome == null) {
            throw new RuntimeException("Tried registering null Biome");
        }
        this.REG.registerBiome(biome);
    }

    @Override
    public void registerBlockStateProviderType(@NotNull BlockStateProviderType<?> blockStateProviderType) {
        if (blockStateProviderType == null) {
            throw new RuntimeException("Tried registering null BlockStateProviderType");
        }
        this.REG.registerBlockStateProviderType(blockStateProviderType);
    }

    @Override
    public void registerBlockPlacerType(@NotNull BlockPlacerType<?> blockPlacerType) {
        if (blockPlacerType == null) {
            throw new RuntimeException("Tried registering null BlockPlacerType");
        }
        this.REG.registerBlockPlacerType(blockPlacerType);
    }

    @Override
    public void registerFoliagePlacerType(@NotNull FoliagePlacerType<?> foliagePlacerType) {
        if (foliagePlacerType == null) {
            throw new RuntimeException("Tried registering null FoliagePlacerType");
        }
        this.REG.registerFoliagePlacerType(foliagePlacerType);
    }

    @Override
    public void registerTreeDecoratorType(@NotNull TreeDecoratorType<?> treeDecoratorType) {
        if (treeDecoratorType == null) {
            throw new RuntimeException("Tried registering null TreeDecoratorType");
        }
        this.REG.registerTreeDecoratorType(treeDecoratorType);
    }

    @Override
    public void registerParticleType(@NotNull ParticleType<? extends IParticleData> particleType) {
        if (particleType == null) {
            throw new RuntimeException("Tried registering null ParticleType");
        }
        this.REG.registerParticleType(particleType);
    }

    @Override
    public void registerBiomeProviderType(@NotNull BiomeProvider biomeProviderType) {
        if (biomeProviderType == null) {
            throw new RuntimeException("Tried registering null BiomeProviderType");
        }
        this.REG.registerBiomeProviderType(biomeProviderType);
    }

    @Override
    public void registerChunkGeneratorType(@NotNull ChunkGenerator chunkGeneratorType) {
        if (chunkGeneratorType == null) {
            throw new RuntimeException("Tried registering null ChunkGeneratorType");
        }
        this.REG.registerChunkGeneratorType(chunkGeneratorType);
    }

    @Override
    public void registerPaintingType(@NotNull PaintingType paintingType) {
        if (paintingType == null) {
            throw new RuntimeException("Tried registering null PaintingType");
        }
        this.REG.registerPaintingType(paintingType);
    }

    @Override
    public void registerCustomStat(@NotNull VLID customStat) {
        if (customStat == null) {
            throw new RuntimeException("Tried registering null CustomStat");
        }
        this.REG.registerCustomStat(customStat);
    }

    @Override
    public void registerChunkStatus(@NotNull ChunkStatus chunkStatus) {
        if (chunkStatus == null) {
            throw new RuntimeException("Tried registering null ChunkStatus");
        }
        this.REG.registerChunkStatus(chunkStatus);
    }

    @Override
    public void registerStructure(@NotNull Structure<?> structure) {
        if (structure == null) {
            throw new RuntimeException("Tried registering null Structure");
        }
        this.REG.registerStructure(structure);
    }

    @Override
    public void registerRuleTestType(@NotNull IRuleTestType ruleTestType) {
        if (ruleTestType == null) {
            throw new RuntimeException("Tried registering null IRuleTestType");
        }
        this.REG.registerRuleTestType(ruleTestType);
    }

    @Override
    public void registerStructureProcessorType(@NotNull IStructureProcessorType structureProcessorType) {
        if (structureProcessorType == null) {
            throw new RuntimeException("Tried registering null IStructureProcessorType");
        }
        this.REG.registerStructureProcessorType(structureProcessorType);
    }

    @Override
    public void registerJigsawDeserializer(@NotNull IJigsawDeserializer jigsawDeserializer) {
        if (jigsawDeserializer == null) {
            throw new RuntimeException("Tried registering null IJigsawDeserializer");
        }
        this.REG.registerJigsawDeserializer(jigsawDeserializer);
    }

    @Override
    public void registerStatType(@NotNull StatType<?> stat) {
        if (stat == null) {
            throw new RuntimeException("Tried registering null StatType");
        }
        this.REG.registerStatType(stat);
    }

    @Override
    public void registerVillagerType(@NotNull VillagerType villagerType) {
        if (villagerType == null) {
            throw new RuntimeException("Tried registering null IVillagerType");
        }
        this.REG.registerVillagerType(villagerType);
    }

    @Override
    public void registerVillagerProfession(@NotNull VillagerProfession villagerProfession) {
        if (villagerProfession == null) {
            throw new RuntimeException("Tried registering null VillagerProfession");
        }
        this.REG.registerVillagerProfession(villagerProfession);
    }

    @Override
    public void registerPointOfInterestType(@NotNull PointOfInterestType pointOfInterestType) {
        if (pointOfInterestType == null) {
            throw new RuntimeException("Tried registering null PointOfInterestType");
        }
        this.REG.registerPointOfInterestType(pointOfInterestType);
    }

    @Override
    public void registerMemoryModuleType(@NotNull MemoryModuleType<?> memoryModuleType) {
        if (memoryModuleType == null) {
            throw new RuntimeException("Tried registering null MemoryModuleType");
        }
        this.REG.registerMemoryModuleType(memoryModuleType);
    }

    @Override
    public void registerSensorType(@NotNull SensorType<?> sensorType) {
        if (sensorType == null) {
            throw new RuntimeException("Tried registering null SensorType");
        }
        this.REG.registerSensorType(sensorType);
    }

    @Override
    public void registerSchedule(@NotNull Schedule schedule) {
        if (schedule == null) {
            throw new RuntimeException("Tried registering null Schedule");
        }
        this.REG.registerSchedule(schedule);
    }

    @Override
    public void registerActivity(@NotNull Activity activity) {
        if (activity == null) {
            throw new RuntimeException("Tried registering null Activity");
        }
        this.REG.registerActivity(activity);
    }

    public void registerTheme(ThemeID themeID) {
        if (themeID == null) {
            throw new RuntimeException("Tried creating theme with id: " + themeID + " but failed in the process");
        }
        this.getThemeRegistry().registerTheme(themeID);
    }

    public abstract ThemeRegistry getThemeRegistry();

    public static ITag<Block> registerTagBlock(@NotNull VLID id) {
        return BlockTags.func_199896_a().func_199910_a((ResourceLocation)id);
    }

    public static ITag<Fluid> registerTagFluid(@NotNull VLID id) {
        return FluidTags.func_226157_a_().func_199910_a((ResourceLocation)id);
    }

    public static ITag<Item> registerTagItem(@NotNull VLID id) {
        return ItemTags.func_199903_a().func_199910_a((ResourceLocation)id);
    }

    public static ITag<EntityType<?>> registerTagEntityType(@NotNull VLID id) {
        return EntityTypeTags.func_219762_a().func_199910_a((ResourceLocation)id);
    }
}

