/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.tooltip;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.core.util.StyleUtil;
import com.valkyrieofnight.vlib.core.util.client.TextComponentUtil;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.tooltip.ITooltipBuilder;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class QuickTooltips {
    public static final Supplier<Boolean> SHIFT = new Supplier<Boolean>(){

        @Override
        public Boolean get() {
            return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344);
        }
    };
    public static final Supplier<Boolean> CTRL = new Supplier<Boolean>(){

        @Override
        public Boolean get() {
            return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)341) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)345);
        }
    };
    public static final Supplier<Boolean> CTRL_SHIFT = new Supplier<Boolean>(){

        @Override
        public Boolean get() {
            return !(!InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)341) && !InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)345) || !InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) && !InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344));
        }
    };

    public static Conditional createConditional(Supplier<Boolean> supplier) {
        return new Conditional(supplier);
    }

    public static List createList() {
        return new List();
    }

    public static Map createMap() {
        return new Map();
    }

    public static IFormattableTextComponent shiftForInfoTooltip() {
        return TextComponentUtil.create(new IFormattableTextComponent[]{new TranslationTextComponent("label.valkyrielib.shift").func_230530_a_(StyleUtil.create(Color4.CYAN)), new StringTextComponent(" "), new TranslationTextComponent("label.valkyrielib.formoreinfo")});
    }

    public static IFormattableTextComponent ctrlForInfoTooltip() {
        return TextComponentUtil.create(new IFormattableTextComponent[]{new TranslationTextComponent("label.valkyrielib.ctrl").func_230530_a_(StyleUtil.create(Color4.CYAN)), new StringTextComponent(" "), new TranslationTextComponent("label.valkyrielib.formoreinfo")});
    }

    public static IFormattableTextComponent shiftAndCtrlForInfoTooltip() {
        return TextComponentUtil.create(new IFormattableTextComponent[]{new TranslationTextComponent("label.valkyrielib.shift").func_230530_a_(StyleUtil.create(Color4.CYAN)), new StringTextComponent("+").func_230530_a_(StyleUtil.create(Color4.CYAN)), new TranslationTextComponent("label.valkyrielib.ctrl").func_230530_a_(StyleUtil.create(Color4.CYAN)), new StringTextComponent(" "), new TranslationTextComponent("label.valkyrielib.formoreinfo")});
    }

    public static class Conditional
    implements ITooltipBuilder {
        protected Supplier<Boolean> condition;
        protected java.util.List trueValues = Lists.newArrayList();
        protected java.util.List falseValues = Lists.newArrayList();

        public Conditional(Supplier<Boolean> condition) {
            this.condition = condition;
        }

        public Conditional addTrue(ITextComponent ... all) {
            for (ITextComponent tc : all) {
                this.trueValues.add(tc);
            }
            return this;
        }

        public Conditional addTrue(java.util.List<? extends ITextComponent> all) {
            for (ITextComponent iTextComponent : all) {
                this.trueValues.add(iTextComponent);
            }
            return this;
        }

        public Conditional addTrue(String str) {
            if (!StringUtils.isNullOrEmpty(str)) {
                this.trueValues.add(new StringTextComponent(str));
            }
            return this;
        }

        public Conditional addFalse(ITextComponent ... all) {
            for (ITextComponent tc : all) {
                this.falseValues.add(tc);
            }
            return this;
        }

        public Conditional addFalse(java.util.List<? extends ITextComponent> all) {
            for (ITextComponent iTextComponent : all) {
                this.falseValues.add(iTextComponent);
            }
            return this;
        }

        public Conditional addFalse(String str) {
            if (!StringUtils.isNullOrEmpty(str)) {
                this.falseValues.add(new StringTextComponent(str));
            }
            return this;
        }

        public boolean getState() {
            return this.condition.get();
        }

        public java.util.List build() {
            if (this.condition.get().booleanValue()) {
                return this.trueValues;
            }
            return this.falseValues;
        }
    }

    public static class Map
    implements ITooltipBuilder {
        private java.util.Map<Integer, ITextComponent> tooltips = Maps.newHashMap();

        public Map() {
        }

        public Map(java.util.Map<Integer, ITextComponent> ttm) {
            this.tooltips.putAll(ttm);
        }

        public void set(int index, ITextComponent component) {
            this.tooltips.put(index, component);
        }

        @Override
        public java.util.List<ITextComponent> build() {
            ArrayList l = Lists.newArrayList();
            this.tooltips.values().forEach(l::add);
            return l;
        }
    }

    public static class List
    implements ITooltipBuilder {
        private ArrayList<ITextComponent> tooltips = new ArrayList();

        public List() {
        }

        public List(java.util.List<ITextComponent> ttl) {
            this.tooltips.addAll(ttl);
        }

        public List add(ITextComponent tooltip) {
            this.tooltips.add(tooltip);
            return this;
        }

        public List addString(String tooltip) {
            if (!StringUtils.isNullOrEmpty(tooltip)) {
                this.tooltips.add((ITextComponent)new StringTextComponent(tooltip));
            }
            return this;
        }

        @Override
        public void buildTo(java.util.List<ITextComponent> tooltips) {
            tooltips.addAll(this.tooltips);
        }

        @Override
        public java.util.List<ITextComponent> build() {
            return this.tooltips;
        }
    }
}

