/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.image;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.screen.IVLScreen;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.IndexElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.ImageElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.MaxScaledImageElement;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;

public class SequenceImageElement
extends ImageElement
implements IElementContainer {
    protected AssetID[] assets;
    protected IndexElement index;
    protected int xSize;
    protected int ySize;

    public SequenceImageElement(String id, int xSize, int ySize, AssetID ... images) {
        super(id, images[0], StandardThemeAssets.COL_DEFAULT_IMAGE_COLOR);
        this.xSize = xSize;
        this.ySize = ySize;
        this.assets = images;
    }

    @Override
    public IVLScreen getScreen() {
        return this.getContainer().getScreen();
    }

    @Override
    public void initContainer() {
        this.index = new IndexElement("index"){

            @Override
            public void addIndices() {
                int i = 0;
                for (AssetID aid : SequenceImageElement.this.assets) {
                    this.addIndex(new MaxScaledImageElement("" + i++, aid, SequenceImageElement.this.xSize, SequenceImageElement.this.ySize));
                }
            }
        };
        this.index.setOwner(this);
        this.index.initContainer();
    }

    public void nextIndex() {
        this.index.setIndex(this.index.getNextIndex());
    }

    public void prevIndex() {
        this.index.setIndex(this.index.getPrevIndex());
    }

    public void setIndex(int ind) {
        this.index.setIndex(ind);
    }

    public int getIndex() {
        return this.index.getNumberIndex();
    }

    @Override
    public void renderBg(MatrixStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        if (!this.render) {
            return;
        }
        this.index.renderBg(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void onThemeChanged(Theme current) {
        super.onThemeChanged(current);
        this.index.onThemeChanged(current);
    }

    @Override
    public void renderFg(MatrixStack matrixStack, double mouseX, double mouseY) {
        this.index.renderFg(matrixStack, mouseX, mouseY);
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    public void mouseReleasedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    public void mouseDraggedResponse(IElement element, double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
    }

    @Override
    public void mouseScrolledResponse(IElement element, double mouseX, double mouseY, double scrolled) {
    }

    @Override
    public void keyPressedResponse(IElement element, int key, int scanCode, int modifiers) {
    }

    @Override
    public void keyReleasedResponse(IElement element, int key, int scanCode, int modifiers) {
    }

    @Override
    public void charTypedResponse(IElement element, char ch, int modifiers) {
    }

    @Override
    public int getContainerOffsetX(IElement ele) {
        return 0;
    }

    @Override
    public int getContainerOffsetY(IElement ele) {
        return 0;
    }

    @Override
    public void drawTooltips(MatrixStack matrixStack, double mouseX, double mouseY) {
    }

    @Override
    public Theme getTheme() {
        return this.getContainer().getTheme();
    }

    @Override
    public void update() {
        this.index.update();
    }
}

