/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.container.rateconfig;

import com.valkyrieofnight.vlib.core.obj.container.rateconfig.IConfigurableIORate;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public interface IHasRateConfigSideMenu {
    @NotNull
    public List<IConfigurableIORate> getRateConfigs();

    default public CompoundNBT saveRateConfigs() {
        CompoundNBT nbt = new CompoundNBT();
        for (IConfigurableIORate config : this.getRateConfigs()) {
            nbt.func_218657_a(config.getID(), (INBT)config.serializeConfigNBT());
        }
        return nbt;
    }

    default public void loadRateConfigs(CompoundNBT nbt) {
        if (nbt != null) {
            for (IConfigurableIORate config : this.getRateConfigs()) {
                if (!nbt.func_74764_b(config.getID())) continue;
                config.deserializeConfigNBT((CompoundNBT)nbt.func_74781_a(config.getID()));
            }
        }
    }

    default public <T> boolean isCapabilitySupported(Capability<T> capability) {
        for (IConfigurableIORate config : this.getRateConfigs()) {
            if (!config.isCapabilitySupported(capability)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    default public <T> LazyOptional<T> getCapabilityHandler(Capability<T> capability) {
        for (IConfigurableIORate config : this.getRateConfigs()) {
            if (!config.isCapabilitySupported(capability)) continue;
            return config.getCapabilityHandler(capability);
        }
        return LazyOptional.empty();
    }

    default public List<Capability<?>> getSupportedCapabilities() {
        ArrayList supportedCapabilities = new ArrayList();
        for (IConfigurableIORate config : this.getRateConfigs()) {
            supportedCapabilities.addAll(config.getCapabilities());
        }
        return supportedCapabilities;
    }
}

