/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.quartzchests.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.latvian.mods.quartzchests.block.QuartzChestsBlocks;
import dev.latvian.mods.quartzchests.block.entity.ColorType;
import dev.latvian.mods.quartzchests.block.entity.QuartzChestEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class QuartzChestRenderer
extends TileEntityRenderer<QuartzChestEntity> {
    private static final RenderMaterial TEXTURE_BASE = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("quartzchests:block/chest_base"));
    private static final RenderMaterial TEXTURE_BORDERS = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("quartzchests:block/chest_borders"));
    private final QuartzChestModel baseModel = new QuartzChestModel();
    private final QuartzChestModel bordersModel = new QuartzChestModel();

    public QuartzChestRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(QuartzChestEntity chest, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer typeBuffer, int combinedLight, int combinedOverlay) {
        World world = chest.func_145831_w();
        BlockState blockstate = world != null ? chest.func_195044_w() : (BlockState)((Block)QuartzChestsBlocks.CHEST.get()).func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.SOUTH);
        matrixStack.func_227860_a_();
        float f = ((Direction)blockstate.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_185119_l();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        if (world != null) {
            double angle = MathHelper.func_219803_d((double)partialTicks, (double)chest.prevLidAngle, (double)chest.lidAngle);
            angle = 1.0 - angle;
            angle = 1.0 - angle * angle * angle;
            ((QuartzChestModel)this.baseModel).top.field_78795_f = ((QuartzChestModel)this.bordersModel).top.field_78795_f = -((float)(angle * Math.PI / 2.0));
        } else {
            ((QuartzChestModel)this.bordersModel).top.field_78795_f = 0.0f;
            ((QuartzChestModel)this.baseModel).top.field_78795_f = 0.0f;
        }
        IVertexBuilder builderBase = TEXTURE_BASE.func_229311_a_(typeBuffer, RenderType::func_228638_b_);
        IVertexBuilder builderBorders = TEXTURE_BORDERS.func_229311_a_(typeBuffer, RenderType::func_228638_b_);
        int baseR = chest.colors[ColorType.CHEST.index] >> 16 & 0xFF;
        int baseG = chest.colors[ColorType.CHEST.index] >> 8 & 0xFF;
        int baseB = chest.colors[ColorType.CHEST.index] >> 0 & 0xFF;
        this.baseModel.func_225598_a_(matrixStack, builderBase, combinedLight, combinedOverlay, (float)baseR / 255.0f, (float)baseG / 255.0f, (float)baseB / 255.0f, 1.0f);
        int borderR = chest.colors[ColorType.BORDER.index] >> 16 & 0xFF;
        int borderG = chest.colors[ColorType.BORDER.index] >> 8 & 0xFF;
        int borderB = chest.colors[ColorType.BORDER.index] >> 0 & 0xFF;
        this.bordersModel.func_225598_a_(matrixStack, builderBorders, combinedLight, combinedOverlay, (float)borderR / 255.0f, (float)borderG / 255.0f, (float)borderB / 255.0f, 1.0f);
        if (!chest.icon.func_190926_b()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, (double)0.33f, (double)0.96f);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            matrixStack.func_227862_a_(0.4f, 0.4f, 0.4f);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(chest.icon, ItemCameraTransforms.TransformType.FIXED, combinedLight, OverlayTexture.field_229196_a_, matrixStack, typeBuffer);
            matrixStack.func_227865_b_();
        }
        if (!chest.func_145830_o() || ((QuartzChestModel)this.baseModel).top.field_78795_f == 0.0f) {
            if (!chest.textGlow || chest.func_145830_o()) {
                // empty if block
            }
            RenderSystem.disableLighting();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableAlphaTest();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, (double)0.78f, (double)0.938f);
            String label = chest.label;
            if (chest.textBold) {
                label = TextFormatting.BOLD + label;
            }
            if (chest.textItalic) {
                label = TextFormatting.ITALIC + label;
            }
            int sw1 = this.field_228858_b_.func_147548_a().func_78256_a(label);
            float f1 = 1.0f / (float)Math.max(sw1 + 30, 64);
            matrixStack.func_227862_a_(f1, -f1, f1);
            this.field_228858_b_.func_147548_a().func_228079_a_(label, (float)(-sw1) / 2.0f, 0.0f, 0xFF000000 | chest.colors[ColorType.TEXT.index], false, matrixStack.func_227866_c_().func_227870_a_(), typeBuffer, false, 0, combinedLight);
            matrixStack.func_227865_b_();
            if (!chest.textGlow || chest.func_145830_o()) {
                // empty if block
            }
        }
        matrixStack.func_227865_b_();
    }

    private static class QuartzChestModel
    extends Model {
        private final ModelRenderer top;
        private final ModelRenderer bottom;

        public QuartzChestModel() {
            super(RenderType::func_228638_b_);
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.bottom = new ModelRenderer((Model)this, 0, 19);
            this.bottom.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
            this.top = new ModelRenderer((Model)this, 0, 0);
            this.top.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
            this.top.field_78797_d = 9.0f;
            this.top.field_78798_e = 1.0f;
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder vertexBuilder, int light1, int light2, float red, float green, float blue, float alpha) {
            this.top.func_228309_a_(matrixStack, vertexBuilder, light1, light2, red, green, blue, alpha);
            this.bottom.func_228309_a_(matrixStack, vertexBuilder, light1, light2, red, green, blue, alpha);
        }
    }
}

