/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FramingRecipe
extends SpecialRecipe {
    public static final IRecipeSerializer<FramingRecipe> SERIALIZER = new Serializer();
    final Ingredient ingredient;
    final boolean includeFront;

    public FramingRecipe(ResourceLocation idIn, Ingredient ingredient, boolean includeFront) {
        super(idIn);
        this.ingredient = ingredient;
        this.includeFront = includeFront;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return !this.getCraftingResult(inv).func_190926_b();
    }

    private static CompoundNBT materialNbt(ItemStack stack) {
        if (stack.func_190916_E() != 1) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
        }
        return stack.func_77955_b(new CompoundNBT());
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        int drawerIndex = -1;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!this.ingredient.test(inv.func_70301_a(i))) continue;
            if (drawerIndex == -1) {
                drawerIndex = i;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (drawerIndex == -1) {
            return ItemStack.field_190927_a;
        }
        int drawerX = drawerIndex % inv.func_174922_i();
        int drawerY = drawerIndex / inv.func_174923_h();
        if (drawerX < 1 || drawerY < 1) {
            return ItemStack.field_190927_a;
        }
        int sideSlot = (drawerY - 1) * inv.func_174923_h() + drawerX - 1;
        int trimSlot = (drawerY - 1) * inv.func_174923_h() + drawerX;
        int frontSlot = drawerY * inv.func_174923_h() + drawerX - 1;
        IntOpenHashSet applicable = new IntOpenHashSet(new int[]{drawerIndex, sideSlot, trimSlot, frontSlot});
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (applicable.contains(i) || inv.func_70301_a(i).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        ItemStack sideStack = inv.func_70301_a(sideSlot);
        if (sideStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack frontStack = inv.func_70301_a(frontSlot);
        if (!this.includeFront && !frontStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack trimStack = inv.func_70301_a(trimSlot);
        ItemStack out = inv.func_70301_a(drawerIndex).func_77946_l();
        out.func_190920_e(1);
        CompoundNBT tag = out.func_196082_o();
        tag.func_218657_a("MatS", (INBT)FramingRecipe.materialNbt(sideStack));
        tag.func_218657_a("MatT", (INBT)FramingRecipe.materialNbt(trimStack));
        if (this.includeFront) {
            tag.func_218657_a("MatF", (INBT)FramingRecipe.materialNbt(frontStack));
        }
        return out;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FramingRecipe> {
        public FramingRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new FramingRecipe(recipeId, Ingredient.func_199802_a((JsonElement)json.get("ingredient")), json.has("includeFront") && json.get("includeFront").getAsBoolean());
        }

        public FramingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new FramingRecipe(recipeId, Ingredient.func_199566_b((PacketBuffer)buffer), buffer.readBoolean());
        }

        public void write(PacketBuffer buffer, FramingRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.writeBoolean(recipe.includeFront);
        }
    }
}

