/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet.debug;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.network.packet.debug.PingPongPacketSync;

public class PingPongPacketAsync
extends PacketCodec {
    @CodecField
    protected int remaining;

    public PingPongPacketAsync() {
    }

    public PingPongPacketAsync(int remaining) {
        this.remaining = remaining;
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    protected void log(PlayerEntity player, String message) {
        player.func_145747_a((ITextComponent)new StringTextComponent(message), Util.field_240973_b_);
    }

    protected PingPongPacketAsync newPacket() {
        return new PingPongPacketSync(this.remaining - 1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(World world, PlayerEntity player) {
        if (this.remaining > 0) {
            CyclopsCore._instance.getPacketHandler().sendToServer(this.newPacket());
        }
        this.log(player, String.format("[PING %s] Fields: %s", this.remaining, this.toString()));
    }

    @Override
    public void actionServer(World world, ServerPlayerEntity player) {
        if (this.remaining > 0) {
            CyclopsCore._instance.getPacketHandler().sendToPlayer(this.newPacket(), player);
        }
        this.log((PlayerEntity)player, String.format("[PONG %s] Fields: %s", this.remaining, this.toString()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List fields = (List)this.fieldCache.get(null);
        for (Field field : fields) {
            sb.append(" ");
            sb.append(field);
            sb.append("=");
            try {
                sb.append(field.get(this));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                sb.append("ERROR(" + e.getMessage() + ")");
            }
        }
        return sb.toString();
    }
}

