/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Random;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.ErrorScreen;
import net.minecraft.client.gui.screen.FlatPresetsScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.FileUtil;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.GeneralConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiMainMenuExtensionDevWorld {
    private static final String WORLD_NAME_PREFIX = "cyclops-dev";
    private static final String PRESET_FLAT_WORLD = "minecraft:bedrock,3*minecraft:stone,52*minecraft:sandstone;minecraft:desert;";
    private static final String PRESET_FLAT_WORLD_JSON = "{\"bonus_chest\":false,\"dimensions\":{\"minecraft:overworld\":{\"type\":\"minecraft:overworld\",\"generator\":{\"settings\":{\"lakes\":false,\"features\":false,\"biome\":\"minecraft:desert\",\"structures\":{\"structures\":{}},\"layers\":[{\"height\":1,\"block\":\"minecraft:bedrock\"},{\"height\":3,\"block\":\"minecraft:stone\"},{\"height\":52,\"block\":\"minecraft:sandstone\"}]},\"type\":\"minecraft:flat\"}},\"minecraft:the_nether\":{\"type\":\"minecraft:the_nether\",\"generator\":{\"biome_source\":{\"preset\":\"minecraft:nether\",\"seed\":-7729799262413108572,\"type\":\"minecraft:multi_noise\"},\"seed\":-7729799262413108572,\"settings\":\"minecraft:nether\",\"type\":\"minecraft:noise\"}},\"minecraft:the_end\":{\"type\":\"minecraft:the_end\",\"generator\":{\"biome_source\":{\"seed\":-7729799262413108572,\"type\":\"minecraft:the_end\"},\"seed\":-7729799262413108572,\"settings\":\"minecraft:end\",\"type\":\"minecraft:noise\"}}},\"seed\":-7729799262413108572,\"generate_features\":false}";

    @SubscribeEvent
    public static void onMainMenuInit(GuiScreenEvent.InitGuiEvent event) {
        if (GeneralConfig.devWorldButton && event.getGui() instanceof MainMenuScreen) {
            event.addWidget((Widget)new Button(event.getGui().field_230708_k_ / 2 + 102, event.getGui().field_230709_l_ / 4 + 48, 58, 20, (ITextComponent)new TranslationTextComponent("general.cyclopscore.dev_world"), button -> {
                String saveName;
                Minecraft mc = Minecraft.func_71410_x();
                if (!MinecraftHelpers.isShifted()) {
                    WorldSummary devWorldSummary = null;
                    mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    try {
                        for (WorldSummary worldSummary : mc.func_71359_d().func_75799_b()) {
                            if (!worldSummary.func_75788_b().equals(WORLD_NAME_PREFIX) || devWorldSummary != null && devWorldSummary.func_75784_e() >= worldSummary.func_75784_e()) continue;
                            devWorldSummary = worldSummary;
                        }
                    }
                    catch (AnvilConverterException e) {
                        CyclopsCore.clog(Level.ERROR, "Couldn't load level list" + e.getMessage());
                        mc.func_147108_a((Screen)new ErrorScreen((ITextComponent)new TranslationTextComponent("selectWorld.unable_to_load"), (ITextComponent)new StringTextComponent(e.getMessage())));
                    }
                    if (devWorldSummary != null && mc.func_71359_d().func_90033_f(devWorldSummary.func_75786_a())) {
                        mc.func_238191_a_(devWorldSummary.func_75786_a());
                        return;
                    }
                }
                GameRules gameRules = new GameRules();
                ((GameRules.BooleanValue)gameRules.func_223585_a(GameRules.field_223607_j)).func_223570_a(false, null);
                ((GameRules.BooleanValue)gameRules.func_223585_a(GameRules.field_226683_z_)).func_223570_a(true, null);
                ((GameRules.BooleanValue)gameRules.func_223585_a(GameRules.field_230127_D_)).func_223570_a(false, null);
                ((GameRules.BooleanValue)gameRules.func_223585_a(GameRules.field_230128_E_)).func_223570_a(false, null);
                WorldSettings worldsettings = new WorldSettings(WORLD_NAME_PREFIX, GameType.CREATIVE, false, Difficulty.PEACEFUL, true, gameRules, DatapackCodec.field_234880_a_);
                int seed = new Random().nextInt();
                DynamicRegistries.Impl dynamicRegistries = DynamicRegistries.func_239770_b_();
                MutableRegistry registryDimensionType = dynamicRegistries.func_243612_b(Registry.field_239698_ad_);
                MutableRegistry registryBiome = dynamicRegistries.func_243612_b(Registry.field_239720_u_);
                MutableRegistry registryDimensionSettings = dynamicRegistries.func_243612_b(Registry.field_243549_ar);
                SimpleRegistry simpleregistry = DimensionType.func_242718_a((Registry)registryDimensionType, (Registry)registryBiome, (Registry)registryDimensionSettings, (long)seed);
                FlatGenerationSettings flatgenerationsettings = FlatPresetsScreen.func_243299_a((Registry)registryBiome, (String)PRESET_FLAT_WORLD, (FlatGenerationSettings)FlatGenerationSettings.func_242869_a((Registry)registryBiome));
                DimensionGeneratorSettings generatorSettings = new DimensionGeneratorSettings((long)seed, false, false, DimensionGeneratorSettings.func_242749_a((Registry)registryDimensionType, (SimpleRegistry)simpleregistry, (ChunkGenerator)new FlatChunkGenerator(flatgenerationsettings)));
                try {
                    saveName = FileUtil.func_214992_a((Path)mc.func_71359_d().func_215781_c(), (String)WORLD_NAME_PREFIX, (String)"");
                }
                catch (IOException e) {
                    saveName = "World";
                }
                mc.func_238192_a_(saveName, worldsettings, dynamicRegistries, generatorSettings);
            }));
        }
    }
}

