/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.util;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.network.PacketHandler;
import com.mrcrayfish.configured.network.message.MessageSyncServerConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHelper {
    private static final Method MOD_CONFIG_SET_CONFIG_DATA = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"setConfigData", (Class[])new Class[]{CommentedConfig.class});
    private static final Method MOD_CONFIG_FIRE_EVENT = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"fireEvent", (Class[])new Class[]{ModConfig.ModConfigEvent.class});
    private static final Constructor<ModConfig.Reloading> MOD_CONFIG_RELOADING = ObfuscationReflectionHelper.findConstructor(ModConfig.Reloading.class, (Class[])new Class[0]);

    public static boolean isModified(ModConfig config) {
        return ConfigHelper.gatherAllConfigValues(config).stream().anyMatch(pair -> !((ForgeConfigSpec.ConfigValue)pair.getLeft()).get().equals(((ForgeConfigSpec.ValueSpec)pair.getRight()).getDefault()));
    }

    public static List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> gatherAllConfigValues(ModConfig config) {
        return ConfigHelper.gatherAllConfigValues(config.getSpec().getValues(), config.getSpec());
    }

    public static List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> gatherAllConfigValues(UnmodifiableConfig config, ForgeConfigSpec spec) {
        ArrayList values = new ArrayList();
        ConfigHelper.gatherValuesFromConfig(config, spec, values);
        return ImmutableList.copyOf(values);
    }

    private static void gatherValuesFromConfig(UnmodifiableConfig config, ForgeConfigSpec spec, List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> values) {
        config.valueMap().forEach((s, o) -> {
            if (o instanceof AbstractConfig) {
                ConfigHelper.gatherValuesFromConfig((UnmodifiableConfig)o, spec, values);
            } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue.getPath());
                values.add(Pair.of((Object)configValue, (Object)valueSpec));
            }
        });
    }

    public static void setConfigData(ModConfig config, @Nullable CommentedConfig configData) {
        try {
            MOD_CONFIG_SET_CONFIG_DATA.invoke((Object)config, configData);
            if (configData instanceof FileConfig) {
                config.save();
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static ModConfig getModConfig(String fileName) {
        ConcurrentHashMap configMap = (ConcurrentHashMap)ObfuscationReflectionHelper.getPrivateValue(ConfigTracker.class, (Object)ConfigTracker.INSTANCE, (String)"fileMap");
        return configMap != null ? (ModConfig)configMap.get(fileName) : null;
    }

    public static void fireEvent(ModConfig config, ModConfig.ModConfigEvent event) {
        try {
            MOD_CONFIG_FIRE_EVENT.invoke((Object)config, event);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static ModConfig.Reloading reloadingEvent() {
        try {
            return MOD_CONFIG_RELOADING.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isConfiguredInstalledOnServer() {
        ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
        if (connection == null) {
            return false;
        }
        NetworkManager manager = connection.func_147298_b();
        return PacketHandler.getPlayChannel().isRemotePresent(manager);
    }

    public static void sendConfigDataToServer(ModConfig config) {
        if (!ConfigHelper.isConfiguredInstalledOnServer()) {
            return;
        }
        try {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (config.getType() == ModConfig.Type.SERVER && minecraft.field_71439_g != null && minecraft.field_71439_g.func_211513_k(2)) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                TomlFormat.instance().createWriter().write((UnmodifiableConfig)config.getConfigData(), (OutputStream)stream);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageSyncServerConfig(config.getFileName(), stream.toByteArray()));
                stream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void resetCache(ModConfig config) {
        ConfigHelper.gatherAllConfigValues(config).forEach(pair -> ((ForgeConfigSpec.ConfigValue)pair.getLeft()).clearCache());
    }
}

