/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.WorldSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfigSelectionScreen
extends ListMenuScreen {
    private final Map<ModConfig.Type, Set<ModConfig>> configMap;

    public ModConfigSelectionScreen(Screen parent, String displayName, ResourceLocation background, Map<ModConfig.Type, Set<ModConfig>> configMap) {
        super(parent, (ITextComponent)new StringTextComponent(displayName), background, 30);
        this.configMap = configMap;
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        Set<ModConfig> serverConfigs;
        Set<ModConfig> commonConfigs;
        Set<ModConfig> clientConfigs = this.configMap.get(ModConfig.Type.CLIENT);
        if (clientConfigs != null) {
            entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(new TranslationTextComponent("configured.gui.title.client_configuration").getString()));
            clientConfigs.forEach(config -> entries.add(new FileItem((ModConfig)config)));
        }
        if ((commonConfigs = this.configMap.get(ModConfig.Type.COMMON)) != null) {
            entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(new TranslationTextComponent("configured.gui.title.common_configuration").getString()));
            commonConfigs.forEach(config -> entries.add(new FileItem((ModConfig)config)));
        }
        if ((serverConfigs = this.configMap.get(ModConfig.Type.SERVER)) != null) {
            entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(new TranslationTextComponent("configured.gui.title.server_configuration").getString()));
            serverConfigs.forEach(config -> entries.add(new FileItem((ModConfig)config)));
        }
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 75, this.field_230709_l_ - 29, 150, 20, DialogTexts.field_240637_h_, button -> this.field_230706_i_.func_147108_a(this.parent)));
    }

    private static ITextComponent createLabelFromModConfig(ModConfig config) {
        String fileName = config.getFileName();
        fileName = fileName.replace(config.getModId() + "-", "");
        fileName = fileName.substring(0, fileName.length() - ".toml".length());
        fileName = FilenameUtils.getName((String)fileName);
        fileName = ConfigScreen.createLabel(fileName);
        return new StringTextComponent(fileName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class FileItem
    extends ListMenuScreen.Item {
        protected final ModConfig config;
        protected final ITextComponent title;
        protected final ITextComponent fileName;
        protected final Button modifyButton;
        @Nullable
        protected final Button restoreButton;
        private final List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> allConfigValues;

        public FileItem(ModConfig config) {
            super(ModConfigSelectionScreen.createLabelFromModConfig(config).getString());
            this.config = config;
            this.title = ModConfigSelectionScreen.createLabelFromModConfig(config);
            this.allConfigValues = ConfigHelper.gatherAllConfigValues(config);
            this.fileName = this.createTrimmedFileName(config.getFileName());
            this.modifyButton = this.createModifyButton(config);
            boolean bl = this.modifyButton.field_230693_o_ = !ConfigScreen.isPlayingGame() || this.config.getType() != ModConfig.Type.SERVER || ConfigHelper.isConfiguredInstalledOnServer() && this.hasRequiredPermission();
            if (config.getType() != ModConfig.Type.SERVER || Minecraft.func_71410_x().field_71439_g != null) {
                this.restoreButton = new IconButton(0, 0, 0, 0, onPress -> this.showRestoreScreen(), (button, matrixStack, mouseX, mouseY) -> {
                    if (button.func_230449_g_()) {
                        if (this.hasRequiredPermission() && button.field_230693_o_) {
                            ModConfigSelectionScreen.this.func_238654_b_(matrixStack, Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("configured.gui.reset_all"), Math.max(ModConfigSelectionScreen.this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
                        } else if (!this.hasRequiredPermission()) {
                            ModConfigSelectionScreen.this.func_238654_b_(matrixStack, Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("configured.gui.no_permission"), Math.max(ModConfigSelectionScreen.this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
                        }
                    }
                });
                this.restoreButton.field_230693_o_ = this.hasRequiredPermission();
                this.updateRestoreDefaultButton();
            } else {
                this.restoreButton = null;
            }
        }

        private void showRestoreScreen() {
            ConfirmationScreen confirmScreen = new ConfirmationScreen(ModConfigSelectionScreen.this, (ITextComponent)new TranslationTextComponent("configured.gui.restore_message"), result -> {
                if (!result.booleanValue() || this.allConfigValues == null) {
                    return true;
                }
                CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableCommentedConfig)this.config.getConfigData());
                this.allConfigValues.forEach(pair -> {
                    ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)pair.getLeft();
                    ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)pair.getRight();
                    newConfig.set(configValue.getPath(), valueSpec.getDefault());
                });
                this.updateRestoreDefaultButton();
                this.config.getConfigData().putAll((UnmodifiableConfig)newConfig);
                ConfigHelper.resetCache(this.config);
                if (this.config.getType() == ModConfig.Type.SERVER) {
                    ConfigHelper.sendConfigDataToServer(this.config);
                }
                return true;
            });
            confirmScreen.setBackground(ModConfigSelectionScreen.this.background);
            confirmScreen.setPositiveText((ITextComponent)new TranslationTextComponent("configured.gui.restore").func_240701_a_(new TextFormatting[]{TextFormatting.GOLD, TextFormatting.BOLD}));
            confirmScreen.setNegativeText(DialogTexts.field_240633_d_);
            Minecraft.func_71410_x().func_147108_a((Screen)confirmScreen);
        }

        private boolean hasRequiredPermission() {
            if (this.config.getType() == ModConfig.Type.SERVER && Minecraft.func_71410_x().field_71439_g != null) {
                return Minecraft.func_71410_x().field_71439_g.func_211513_k(2);
            }
            return true;
        }

        private ITextComponent createTrimmedFileName(String fileName) {
            IFormattableTextComponent trimmedFileName = new StringTextComponent(fileName).func_240699_a_(TextFormatting.GRAY);
            if (Minecraft.func_71410_x().field_71466_p.func_78256_a(fileName) > 160) {
                trimmedFileName = new StringTextComponent(Minecraft.func_71410_x().field_71466_p.func_238412_a_(fileName, 150) + "...").func_240699_a_(TextFormatting.GRAY);
            }
            return trimmedFileName;
        }

        private Button createModifyButton(ModConfig config) {
            boolean serverConfig = config.getType() == ModConfig.Type.SERVER && Minecraft.func_71410_x().field_71441_e == null;
            String langKey = serverConfig ? "configured.gui.select_world" : "configured.gui.modify";
            return new IconButton(0, 0, serverConfig ? 44 : 33, 0, serverConfig ? 80 : 60, (ITextComponent)new TranslationTextComponent(langKey), onPress -> {
                if (!(!ConfigScreen.isPlayingGame() || this.config.getType() != ModConfig.Type.SERVER || ConfigHelper.isConfiguredInstalledOnServer() && this.hasRequiredPermission())) {
                    return;
                }
                if (serverConfig) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new WorldSelectionScreen((Screen)ModConfigSelectionScreen.this, ModConfigSelectionScreen.this.background, config, this.title));
                } else {
                    ModList.get().getModContainerById(config.getModId()).ifPresent(container -> Minecraft.func_71410_x().func_147108_a((Screen)new ConfigScreen((Screen)ModConfigSelectionScreen.this, (ITextComponent)new StringTextComponent(container.getModInfo().getDisplayName()), config, ModConfigSelectionScreen.this.background)));
                }
            }, (button, matrixStack, mouseX, mouseY) -> {
                if (button.func_230449_g_()) {
                    if (ConfigScreen.isPlayingGame() && !ConfigHelper.isConfiguredInstalledOnServer()) {
                        ModConfigSelectionScreen.this.func_238654_b_(matrixStack, Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("configured.gui.not_installed"), Math.max(ModConfigSelectionScreen.this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
                    } else if (!this.hasRequiredPermission()) {
                        ModConfigSelectionScreen.this.func_238654_b_(matrixStack, Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("configured.gui.no_permission"), Math.max(ModConfigSelectionScreen.this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
                    }
                }
            });
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            AbstractGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)this.title, (int)(left + 28), (int)(top + 2), (int)0xFFFFFF);
            AbstractGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)this.fileName, (int)(left + 28), (int)(top + 12), (int)0xFFFFFF);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(IconButton.ICONS);
            float brightness = 1.0f;
            RenderSystem.color4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
            AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)(left + 4), (int)top, (int)18, (int)22, (float)this.getIconU(), (float)11.0f, (int)9, (int)11, (int)64, (int)64);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.modifyButton.field_230690_l_ = left + width - 83;
            this.modifyButton.field_230691_m_ = top;
            this.modifyButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.restoreButton != null) {
                this.restoreButton.field_230690_l_ = left + width - 21;
                this.restoreButton.field_230691_m_ = top;
                this.restoreButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
        }

        private int getIconU() {
            switch (this.config.getType()) {
                case COMMON: {
                    return 9;
                }
                case SERVER: {
                    return 18;
                }
            }
            return 0;
        }

        @Override
        public List<? extends IGuiEventListener> func_231039_at__() {
            if (this.restoreButton != null) {
                return ImmutableList.of((Object)this.modifyButton, (Object)this.restoreButton);
            }
            return ImmutableList.of((Object)this.modifyButton);
        }

        private void updateRestoreDefaultButton() {
            if (this.config != null && this.restoreButton != null && this.hasRequiredPermission()) {
                this.restoreButton.field_230693_o_ = ConfigHelper.isModified(this.config);
            }
        }
    }
}

