/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client;

import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.ModConfigSelectionScreen;
import com.mrcrayfish.configured.client.util.OptiFineHelper;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.gui.screen.ModListScreen;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="configured", value={Dist.CLIENT})
public class ClientHandler {
    public static final KeyBinding KEY_OPEN_MOD_LIST = new KeyBinding("key.configured.open_mod_list", -1, "key.categories.configured");

    public static void registerKeyBindings() {
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_OPEN_MOD_LIST);
    }

    public static void generateConfigFactories() {
        Configured.LOGGER.info("Creating config GUI factories...");
        ModList.get().forEachModContainer((modId, container) -> {
            if (container.getCustomExtension(ExtensionPoint.CONFIGGUIFACTORY).isPresent()) {
                return;
            }
            Map<ModConfig.Type, Set<ModConfig>> modConfigMap = ClientHandler.createConfigMap(container);
            if (!modConfigMap.isEmpty()) {
                Configured.LOGGER.info("Registering config factory for mod {}. Found {} client config(s) and {} common config(s)", modId, modConfigMap.getOrDefault(ModConfig.Type.CLIENT, Collections.emptySet()), modConfigMap.getOrDefault(ModConfig.Type.COMMON, Collections.emptySet()));
                String displayName = container.getModInfo().getDisplayName();
                ResourceLocation backgroundTexture = ClientHandler.getBackgroundTexture(container.getModInfo());
                container.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> new ModConfigSelectionScreen((Screen)screen, displayName, backgroundTexture, modConfigMap));
            }
        });
    }

    private static EnumMap<ModConfig.Type, Set<ModConfig>> getConfigSets() {
        return (EnumMap)ObfuscationReflectionHelper.getPrivateValue(ConfigTracker.class, (Object)ConfigTracker.INSTANCE, (String)"configSets");
    }

    private static Map<ModConfig.Type, Set<ModConfig>> createConfigMap(ModContainer container) {
        HashMap<ModConfig.Type, Set<ModConfig>> modConfigMap = new HashMap<ModConfig.Type, Set<ModConfig>>();
        ClientHandler.addConfigSetToMap(container, ModConfig.Type.CLIENT, modConfigMap);
        ClientHandler.addConfigSetToMap(container, ModConfig.Type.COMMON, modConfigMap);
        ClientHandler.addConfigSetToMap(container, ModConfig.Type.SERVER, modConfigMap);
        return modConfigMap;
    }

    private static void addConfigSetToMap(ModContainer container, ModConfig.Type type, Map<ModConfig.Type, Set<ModConfig>> configMap) {
        if (type == ModConfig.Type.CLIENT && OptiFineHelper.isLoaded() && container.getModId().equals("forge")) {
            Configured.LOGGER.info("Ignoring Forge's client config since OptiFine was detected");
            return;
        }
        Set configSet = ClientHandler.getConfigSets().getOrDefault(type, Collections.emptySet()).stream().filter(config -> config.getModId().equals(container.getModId())).collect(Collectors.toSet());
        if (!configSet.isEmpty()) {
            configMap.put(type, configSet);
        }
    }

    private static ResourceLocation getBackgroundTexture(IModInfo info) {
        Optional optional;
        String configBackground = (String)info.getModProperties().get("configuredBackground");
        if (configBackground != null) {
            return new ResourceLocation(configBackground);
        }
        if (info instanceof ModInfo && (optional = ((ModInfo)info).getConfigElement(new String[]{"configBackground"})).isPresent()) {
            return new ResourceLocation((String)optional.get());
        }
        return AbstractGui.field_230663_f_;
    }

    public static void updateAbstractListTexture(AbstractList<?> list) {
        if (list instanceof IBackgroundTexture) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(((IBackgroundTexture)list).getBackgroundTexture());
        }
    }

    public static void updateScreenTexture(Screen screen) {
        if (screen instanceof IBackgroundTexture) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(((IBackgroundTexture)screen).getBackgroundTexture());
        }
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.KeyInputEvent event) {
        if (KEY_OPEN_MOD_LIST.getKey().func_197937_c() == event.getKey() && event.getAction() == 1) {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft.field_71439_g == null) {
                return;
            }
            Screen oldScreen = minecraft.field_71462_r;
            minecraft.func_147108_a((Screen)new ModListScreen(oldScreen));
        }
    }
}

