/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.serverconfigupdater;

import com.darkere.serverconfigupdater.CommonConfig;
import com.darkere.serverconfigupdater.FileList;
import com.darkere.serverconfigupdater.ServerConfig;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="serverconfigupdater")
public class ServerConfigUpdater {
    public static final String MODID = "serverconfigupdater";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final CommonConfig COMMON_CONFIG = new CommonConfig();
    public static final ServerConfig SERVER_CONFIG = new ServerConfig();

    public ServerConfigUpdater() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, COMMON_CONFIG.getSpec());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_CONFIG.getSpec());
    }

    private void setup(FMLCommonSetupEvent event) {
        COMMON_CONFIG.updateVersionHistory();
        FileList list = new FileList();
        list.tryDeletingFiles();
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerAboutToStartEvent event) {
        COMMON_CONFIG.updateVersionHistory();
        Field configsets = null;
        try {
            configsets = ConfigTracker.class.getDeclaredField("configSets");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        if (configsets == null) {
            return;
        }
        configsets.setAccessible(true);
        EnumMap sets = null;
        try {
            sets = (EnumMap)configsets.get(ConfigTracker.INSTANCE);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        Set configs = (Set)sets.get(ModConfig.Type.SERVER);
        HashSet toReset = new HashSet();
        Set<String> modIDsToReset = COMMON_CONFIG.getModIDsToReset();
        if (modIDsToReset.isEmpty()) {
            return;
        }
        configs.forEach(x -> {
            if (modIDsToReset.contains(x.getModId())) {
                toReset.add(x);
                modIDsToReset.remove(x.getModId());
            }
        });
        modIDsToReset.forEach(x -> LOGGER.warn("No ServerConfig for MODID" + x + " found!"));
        MinecraftServer server = event.getServer();
        Path serverConfig = server.func_240776_a_(new FolderName("serverconfig"));
        for (ModConfig modConfig : toReset) {
            String fileName = ConfigTracker.INSTANCE.getConfigFileName(modConfig.getModId(), ModConfig.Type.SERVER);
            File file = new File(fileName);
            file.delete();
        }
        Method openConfig = null;
        try {
            openConfig = ConfigTracker.class.getDeclaredMethod("openConfig", ModConfig.class, Path.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (openConfig == null) {
            return;
        }
        openConfig.setAccessible(true);
        try {
            for (ModConfig modConfig : toReset) {
                openConfig.invoke((Object)ConfigTracker.INSTANCE, modConfig, serverConfig);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

