/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.serverconfigupdater;

import com.darkere.serverconfigupdater.ServerConfigUpdater;
import com.electronwill.nightconfig.core.utils.StringUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    private ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private ForgeConfigSpec spec;
    private char versionToModIDSeparator = (char)61;
    private char versionSeparator = (char)59;
    private char modIDSeparator = (char)44;
    private ForgeConfigSpec.ConfigValue<String> toDelete;
    private ForgeConfigSpec.IntValue newVersion;
    private ForgeConfigSpec.ConfigValue<String> history;
    private Map<Integer, String> versionhistory = new LinkedHashMap<Integer, String>();
    private ForgeConfigSpec.ConfigValue<String> filesToDelete;
    private ForgeConfigSpec.BooleanValue deleteFolders;

    public CommonConfig() {
        this.buildConfig();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    private void buildConfig() {
        this.builder.push("Add New Version");
        this.newVersion = this.builder.comment("Version Number. VersionNumbers are simple Integers. Use a number larger than the last version.").defineInRange("newVersion", 0, 0, Integer.MAX_VALUE);
        this.toDelete = this.builder.comment("ModID's of the ServerConfigs that will be deleted when a world with a version lower than this version is loaded the first time. Comma Separated list. (ServerConfig without -server.toml)").define("toDelete", (Object)"");
        this.builder.pop();
        this.builder.push("File Deleter");
        this.filesToDelete = this.builder.comment("This is intended for deleting datapacks and/or craft tweaker scripts. The file will be deleted every launch if it exists! No access to saves or world folder. Specify the path to the file. Comma Separated List. Example: scripts/badscript.zs").define("filesToDelete", (Object)"");
        this.deleteFolders = this.builder.comment("By default Folders are only deleted if they are empty. Set to true to change that.").define("deleteFoldersWithContent", false);
        this.builder.pop();
        this.builder.push("Version History");
        this.history = this.builder.comment("Editing these values will not affect any worlds that are already on that version.").define("history", (Object)"");
        this.builder.pop();
        this.spec = this.builder.build();
    }

    public boolean shouldDeleteFolders() {
        return (Boolean)this.deleteFolders.get();
    }

    public List<Path> getFilesToDelete() {
        String files = (String)this.filesToDelete.get();
        if (files.isEmpty()) {
            return new ArrayList<Path>();
        }
        List strings = StringUtils.split((String)files, (char)this.modIDSeparator);
        return strings.stream().map(x -> Paths.get(x, new String[0])).collect(Collectors.toList());
    }

    private void readVersionhistory() {
        String toRead = (String)this.history.get();
        List list = StringUtils.split((String)toRead, (char)this.versionSeparator);
        for (String s : list) {
            List strings;
            int version;
            if (s.isEmpty() || (version = Integer.parseInt((String)(strings = StringUtils.split((String)s, (char)this.versionToModIDSeparator)).get(0))) == 0) continue;
            this.versionhistory.put(version, (String)strings.get(1));
        }
    }

    public Set<String> getModIDsToReset() {
        int version = ServerConfigUpdater.SERVER_CONFIG.getCurrentVersion();
        HashSet<String> modIDs = new HashSet<String>();
        int maxversion = version;
        for (Map.Entry<Integer, String> entry : this.versionhistory.entrySet()) {
            if (entry.getKey() <= version) continue;
            maxversion = entry.getKey();
            List strings = StringUtils.split((String)entry.getValue(), (char)this.modIDSeparator);
            strings.forEach(s -> {
                s = s.trim();
            });
            modIDs.addAll(strings);
        }
        ServerConfigUpdater.SERVER_CONFIG.setVersion(maxversion);
        return modIDs;
    }

    public void updateVersionHistory() {
        this.readVersionhistory();
        if ((Integer)this.newVersion.get() != 0) {
            this.versionhistory.put((Integer)this.newVersion.get(), (String)this.toDelete.get());
            this.newVersion.set((Object)0);
            this.toDelete.set((Object)"");
        }
        this.writeVersionHistory();
    }

    private void writeVersionHistory() {
        StringBuilder builder = new StringBuilder();
        this.versionhistory.forEach((i, s) -> builder.append(i).append(this.versionToModIDSeparator).append((String)s).append(this.versionSeparator));
        this.history.set((Object)builder.toString());
    }
}

