/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.network.packet;

import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.OffhandCooldownTracker;

public class SwingArmPacket
implements IThreadsafePacket {
    private final int entityId;
    private final Hand hand;

    public SwingArmPacket(Entity entity, Hand hand) {
        this.entityId = entity.func_145782_y();
        this.hand = hand;
    }

    public SwingArmPacket(PacketBuffer buffer) {
        this.entityId = buffer.func_150792_a();
        this.hand = (Hand)buffer.func_179257_a(Hand.class);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.entityId);
        buffer.func_179249_a((Enum)this.hand);
    }

    @Override
    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(SwingArmPacket packet) {
            Entity entity;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (entity = world.func_73045_a(packet.entityId)) instanceof LivingEntity) {
                OffhandCooldownTracker.swingHand((LivingEntity)entity, packet.hand, false);
            }
        }
    }
}

