/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.util.ModelTextureIteratable;
import slimeknights.mantle.util.JsonHelper;

public class NBTKeyModel
implements IModelGeometry<NBTKeyModel> {
    public static final Loader LOADER = new Loader();
    private static final Multimap<ResourceLocation, Pair<String, ResourceLocation>> EXTRA_TEXTURES = HashMultimap.create();
    private final String nbtKey;
    @Nullable
    private final ResourceLocation extraTexturesKey;
    private Map<String, RenderMaterial> textures = Collections.emptyMap();

    public static void registerExtraTexture(ResourceLocation key, String textureName, ResourceLocation texture) {
        EXTRA_TEXTURES.put((Object)key, (Object)Pair.of((Object)textureName, (Object)texture));
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        IUnbakedModel model;
        this.textures = new HashMap<String, RenderMaterial>();
        RenderMaterial defaultTexture = owner.resolveTexture("default");
        this.textures.put("default", defaultTexture);
        if (Objects.equals(defaultTexture.func_229313_b_(), MissingTextureSprite.func_195675_b())) {
            missingTextureErrors.add((Pair<String, String>)Pair.of((Object)"default", (Object)owner.getModelName()));
        }
        if ((model = owner.getOwnerModel()) instanceof BlockModel) {
            ModelTextureIteratable iterable = new ModelTextureIteratable(null, (BlockModel)model);
            for (Map map : iterable) {
                for (String key : map.keySet()) {
                    if (this.textures.containsKey(key) || !owner.isTexturePresent(key)) continue;
                    this.textures.put(key, owner.resolveTexture(key));
                }
            }
        }
        if (this.extraTexturesKey != null) {
            for (Pair extra : EXTRA_TEXTURES.get((Object)this.extraTexturesKey)) {
                String key = (String)extra.getFirst();
                if (this.textures.containsKey(key)) continue;
                this.textures.put(key, ModelLoaderRegistry.blockMaterial((ResourceLocation)((ResourceLocation)extra.getSecond())));
            }
        }
        return this.textures.values();
    }

    private static IBakedModel bakeModel(IModelConfiguration owner, RenderMaterial texture, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transformMap, ItemOverrideList overrides) {
        TextureAtlasSprite sprite = spriteGetter.apply(texture);
        ImmutableList quads = ItemLayerModel.getQuadsForSprite((int)-1, (TextureAtlasSprite)sprite, (TransformationMatrix)TransformationMatrix.func_227983_a_());
        return new BakedItemModel(quads, sprite, transformMap, overrides, true, owner.isSideLit());
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        ImmutableMap.Builder variants = ImmutableMap.builder();
        ImmutableMap transformMap = Maps.immutableEnumMap((Map)PerspectiveMapWrapper.getTransforms((IModelTransform)owner.getCombinedTransform()));
        for (Map.Entry<String, RenderMaterial> entry : this.textures.entrySet()) {
            String key = entry.getKey();
            if (key.equals("default")) continue;
            variants.put((Object)key, (Object)NBTKeyModel.bakeModel(owner, entry.getValue(), spriteGetter, (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)transformMap, ItemOverrideList.field_188022_a));
        }
        return NBTKeyModel.bakeModel(owner, this.textures.get("default"), spriteGetter, (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)transformMap, new Overrides(this.nbtKey, this.textures, (Map<String, IBakedModel>)variants.build()));
    }

    public NBTKeyModel(String nbtKey, @Nullable ResourceLocation extraTexturesKey) {
        this.nbtKey = nbtKey;
        this.extraTexturesKey = extraTexturesKey;
    }

    private static class Loader
    implements IModelLoader<NBTKeyModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public NBTKeyModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            String key = JSONUtils.func_151200_h((JsonObject)modelContents, (String)"nbt_key");
            ResourceLocation extraTexturesKey = null;
            if (modelContents.has("extra_textures_key")) {
                extraTexturesKey = JsonHelper.getResourceLocation(modelContents, "extra_textures_key");
            }
            return new NBTKeyModel(key, extraTexturesKey);
        }
    }

    public static class Overrides
    extends ItemOverrideList {
        private final String nbtKey;
        private final Map<String, RenderMaterial> textures;
        private final Map<String, IBakedModel> variants;

        public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity livingEntity) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt != null && nbt.func_74764_b(this.nbtKey)) {
                return this.variants.getOrDefault(nbt.func_74779_i(this.nbtKey), model);
            }
            return model;
        }

        public RenderMaterial getTexture(String name) {
            RenderMaterial texture = this.textures.get(name);
            return texture != null ? texture : this.textures.get("default");
        }

        public Overrides(String nbtKey, Map<String, RenderMaterial> textures, Map<String, IBakedModel> variants) {
            this.nbtKey = nbtKey;
            this.textures = textures;
            this.variants = variants;
        }
    }
}

