/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.MathHelper;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.device.IFluxStorage;
import sonar.fluxnetworks.api.network.FluxDeviceType;
import sonar.fluxnetworks.api.network.ITransferHandler;
import sonar.fluxnetworks.common.connection.transfer.FluxStorageHandler;
import sonar.fluxnetworks.common.misc.FluxGuiStack;
import sonar.fluxnetworks.common.network.S2CNetMsg;
import sonar.fluxnetworks.common.registry.RegistryBlocks;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public abstract class TileFluxStorage
extends TileFluxDevice
implements IFluxStorage {
    public static final int PRI_DIFF = 1000000;
    public static final int PRI_UPPER = -10000;
    private static final int FLAG_ENERGY_CHANGED = 512;
    private final FluxStorageHandler handler = new FluxStorageHandler(this);

    public TileFluxStorage(TileEntityType<? extends TileFluxStorage> tileEntityTypeIn, String customName, long limit) {
        super(tileEntityTypeIn, customName, limit);
    }

    @Override
    protected void sTick() {
        super.sTick();
        if ((this.flags & 0x200) == 512 && (this.field_145850_b.func_72912_H().func_82573_f() & 3L) == 0L) {
            S2CNetMsg.tileEntity(this, (byte)-2).sendToTrackingChunk(this.field_145850_b.func_175726_f(this.field_174879_c));
            this.flags &= 0xFFFFFDFF;
        }
    }

    public void markServerEnergyChanged() {
        this.flags |= 0x200;
    }

    @Override
    public FluxDeviceType getDeviceType() {
        return FluxDeviceType.STORAGE;
    }

    @Override
    @Nonnull
    public ITransferHandler getTransferHandler() {
        return this.handler;
    }

    @Override
    public int getLogicPriority() {
        return this.surgeMode ? -10000 : this.priority - 1000000;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = MathHelper.func_76125_a((int)priority, (int)-2146483648, (int)989999);
    }

    @Nonnull
    protected ItemStack writeToDisplayStack(@Nonnull ItemStack stack) {
        CompoundNBT subTag = stack.func_190925_c("FluxData");
        if (this.field_145850_b.field_72995_K) {
            stack.func_196082_o().func_74757_a("FluxColor", true);
        } else {
            stack.func_196082_o().func_74757_a("FluxColor", false);
            subTag.func_74768_a("clientColor", this.network.getNetworkColor());
        }
        subTag.func_74772_a("energy", this.getTransferBuffer());
        return stack;
    }

    public static class Gargantuan
    extends TileFluxStorage {
        public Gargantuan() {
            super((TileEntityType<? extends TileFluxStorage>)RegistryBlocks.GARGANTUAN_FLUX_STORAGE_TILE, "Gargantuan Storage", FluxConfig.gargantuanTransfer);
        }

        @Override
        public long getMaxTransferLimit() {
            return FluxConfig.gargantuanCapacity;
        }

        @Override
        @Nonnull
        public ItemStack getDisplayStack() {
            return this.writeToDisplayStack(FluxGuiStack.GARGANTUAN_STORAGE);
        }
    }

    public static class Herculean
    extends TileFluxStorage {
        public Herculean() {
            super((TileEntityType<? extends TileFluxStorage>)RegistryBlocks.HERCULEAN_FLUX_STORAGE_TILE, "Herculean Storage", FluxConfig.herculeanTransfer);
        }

        @Override
        public long getMaxTransferLimit() {
            return FluxConfig.herculeanCapacity;
        }

        @Override
        @Nonnull
        public ItemStack getDisplayStack() {
            return this.writeToDisplayStack(FluxGuiStack.HERCULEAN_STORAGE);
        }
    }

    public static class Basic
    extends TileFluxStorage {
        public Basic() {
            super((TileEntityType<? extends TileFluxStorage>)RegistryBlocks.BASIC_FLUX_STORAGE_TILE, "Basic Storage", FluxConfig.basicTransfer);
        }

        @Override
        public long getMaxTransferLimit() {
            return FluxConfig.basicCapacity;
        }

        @Override
        @Nonnull
        public ItemStack getDisplayStack() {
            return this.writeToDisplayStack(FluxGuiStack.BASIC_STORAGE);
        }
    }
}

