/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.misc.FluxCapabilities;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.ISuperAdmin;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.SecurityType;
import sonar.fluxnetworks.common.capability.SuperAdmin;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.network.NetworkHandler;
import sonar.fluxnetworks.common.registry.RegistryItems;
import sonar.fluxnetworks.common.storage.FluxChunkManager;
import sonar.fluxnetworks.common.storage.FluxNetworkData;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public final class S2CNetMsg {
    private static final NetworkHandler sNetwork = NetworkHandler.sInstance;
    static final Functor[] sFunctors = new Functor[]{S2CNetMsg::tileEntity, S2CNetMsg::responseSuperAdmin, S2CNetMsg::editMember, S2CNetMsg::editNetwork, S2CNetMsg::editWireless, S2CNetMsg::responseNetworkUpdate, S2CNetMsg::setNetwork, S2CNetMsg::createNetwork, S2CNetMsg::deleteNetwork, S2CNetMsg::responseAccessUpdate, S2CNetMsg::editConnections, S2CNetMsg::responseConnectionUpdate, S2CNetMsg::configuratorNet, S2CNetMsg::configuratorEdit};

    @Nonnull
    public static NetworkHandler.Broadcaster tileEntity(@Nonnull TileFluxDevice tile, byte type) {
        PacketBuffer buf = sNetwork.targetAt(0);
        buf.func_179255_a(tile.func_174877_v());
        buf.writeByte((int)type);
        tile.writePacket(buf, type);
        return sNetwork.getBroadcaster(buf);
    }

    private static void feedback(@Nonnull FeedbackInfo info, @Nonnull ServerPlayerEntity player) {
        PacketBuffer buf = sNetwork.targetAt(1);
        buf.func_150787_b(info.ordinal());
        sNetwork.getBroadcaster(buf).sendToPlayer(player);
    }

    @Nonnull
    public static NetworkHandler.Broadcaster updateSuperAdmin(boolean hasPermission) {
        PacketBuffer buf = sNetwork.targetAt(2);
        buf.writeBoolean(hasPermission);
        return sNetwork.getBroadcaster(buf);
    }

    @Nonnull
    public static NetworkHandler.Broadcaster lavaEffect(BlockPos pos, int count) {
        PacketBuffer buf = sNetwork.targetAt(3);
        buf.func_179255_a(pos);
        buf.func_150787_b(count);
        return sNetwork.getBroadcaster(buf);
    }

    @Nonnull
    public static NetworkHandler.Broadcaster updateNetwork(@Nonnull IFluxNetwork net, int type) {
        PacketBuffer buf = sNetwork.targetAt(4);
        buf.func_150787_b(type);
        buf.func_150787_b(1);
        buf.func_150787_b(net.getNetworkID());
        CompoundNBT tag = new CompoundNBT();
        net.writeCustomNBT(tag, type);
        buf.func_150786_a(tag);
        return sNetwork.getBroadcaster(buf);
    }

    @Nonnull
    public static NetworkHandler.Broadcaster updateNetwork(@Nonnull Collection<IFluxNetwork> networks, int type) {
        PacketBuffer buf = sNetwork.targetAt(4);
        buf.func_150787_b(type);
        buf.func_150787_b(networks.size());
        networks.forEach(net -> {
            buf.func_150787_b(net.getNetworkID());
            CompoundNBT tag = new CompoundNBT();
            net.writeCustomNBT(tag, type);
            buf.func_150786_a(tag);
        });
        return sNetwork.getBroadcaster(buf);
    }

    private static void updateAccess(@Nonnull AccessLevel access, ServerPlayerEntity player) {
        PacketBuffer buf = sNetwork.targetAt(5);
        buf.func_150787_b(access.ordinal());
        sNetwork.getBroadcaster(buf).sendToPlayer(player);
    }

    private static void updateConnection(int networkID, @Nonnull List<CompoundNBT> tags, ServerPlayerEntity player) {
        PacketBuffer buf = sNetwork.targetAt(6);
        buf.func_150787_b(networkID);
        buf.func_150787_b(tags.size());
        tags.forEach(arg_0 -> ((PacketBuffer)buf).func_150786_a(arg_0));
        sNetwork.getBroadcaster(buf).sendToPlayer(player);
    }

    private static void tileEntity(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        TileEntity tile = player.field_70170_p.func_175625_s(buf.func_179259_c());
        if (tile instanceof TileFluxDevice) {
            TileFluxDevice flux = (TileFluxDevice)tile;
            if (!flux.canPlayerAccess((PlayerEntity)player)) {
                return;
            }
            byte type = buf.readByte();
            flux.readPacket(buf, type);
            if (type == 6 && !FluxConfig.enableChunkLoading) {
                S2CNetMsg.feedback(FeedbackInfo.BANNED_LOADING, player);
            }
        }
    }

    private static void responseSuperAdmin(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        ISuperAdmin sa = (ISuperAdmin)FluxUtils.get(player.getCapability(FluxCapabilities.SUPER_ADMIN));
        if (sa != null && (sa.hasPermission() || SuperAdmin.canActivateSuperAdmin((PlayerEntity)player))) {
            sa.changePermission();
            if (sa.hasPermission()) {
                S2CNetMsg.feedback(FeedbackInfo.SA_ON, player);
            } else {
                S2CNetMsg.feedback(FeedbackInfo.SA_OFF, player);
            }
            S2CNetMsg.updateSuperAdmin(sa.hasPermission()).sendToPlayer(player);
        }
    }

    private static void editMember(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity sender) {
        IFluxNetwork network = FluxNetworkData.getNetwork(buf.func_150792_a());
        if (!network.isValid()) {
            return;
        }
        AccessLevel senderAccess = network.getPlayerAccess((PlayerEntity)sender);
        if (!senderAccess.canEdit()) {
            S2CNetMsg.feedback(FeedbackInfo.NO_ADMIN, sender);
            return;
        }
        UUID targetUUID = buf.func_179253_g();
        int type = buf.func_150792_a();
        boolean self = PlayerEntity.func_146094_a((GameProfile)sender.func_146103_bH()).equals(targetUUID);
        Optional<NetworkMember> current = network.getMemberByUUID(targetUUID);
        if (type == 1) {
            ServerPlayerEntity target = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(targetUUID);
            if (target != null && !current.isPresent()) {
                NetworkMember m = NetworkMember.create((PlayerEntity)target, AccessLevel.USER);
                network.getRawMemberMap().put((Object)m.getPlayerUUID(), (Object)m);
                S2CNetMsg.feedback(FeedbackInfo.SUCCESS, sender);
                S2CNetMsg.updateNetwork(network, 22).sendToPlayer(sender);
            } else {
                S2CNetMsg.feedback(FeedbackInfo.INVALID_USER, sender);
            }
        } else if (current.isPresent()) {
            NetworkMember c = current.get();
            if (self || c.getAccessLevel() == AccessLevel.OWNER) {
                return;
            }
            if (type == 2) {
                if (!senderAccess.canDelete()) {
                    S2CNetMsg.feedback(FeedbackInfo.NO_OWNER, sender);
                    return;
                }
                c.setAccessLevel(AccessLevel.ADMIN);
            } else if (type == 3) {
                c.setAccessLevel(AccessLevel.USER);
            } else if (type == 4) {
                network.getRawMemberMap().remove((Object)targetUUID);
            } else if (type == 5) {
                if (!senderAccess.canDelete()) {
                    S2CNetMsg.feedback(FeedbackInfo.NO_OWNER, sender);
                    return;
                }
                network.getAllMembers().removeIf(f -> f.getAccessLevel().canDelete());
                network.setOwnerUUID(targetUUID);
                c.setAccessLevel(AccessLevel.OWNER);
            }
            S2CNetMsg.feedback(FeedbackInfo.SUCCESS, sender);
            S2CNetMsg.updateNetwork(network, 22).sendToPlayer(sender);
        } else if (type == 5) {
            if (!senderAccess.canDelete()) {
                S2CNetMsg.feedback(FeedbackInfo.NO_OWNER, sender);
                return;
            }
            if (self && senderAccess == AccessLevel.OWNER) {
                return;
            }
            ServerPlayerEntity target = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(targetUUID);
            if (target != null) {
                network.getAllMembers().removeIf(f -> f.getAccessLevel().canDelete());
                NetworkMember m = NetworkMember.create((PlayerEntity)target, AccessLevel.OWNER);
                network.getRawMemberMap().put((Object)m.getPlayerUUID(), (Object)m);
                network.setOwnerUUID(targetUUID);
                S2CNetMsg.feedback(FeedbackInfo.SUCCESS, sender);
                S2CNetMsg.updateNetwork(network, 22).sendToPlayer(sender);
            } else {
                S2CNetMsg.feedback(FeedbackInfo.INVALID_USER, sender);
            }
        } else {
            S2CNetMsg.feedback(FeedbackInfo.INVALID_USER, sender);
        }
    }

    private static void editNetwork(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        IFluxNetwork network = FluxNetworkData.getNetwork(buf.func_150792_a());
        if (!network.isValid()) {
            return;
        }
        String name = buf.func_150789_c(256);
        int color = buf.readInt();
        SecurityType security = SecurityType.values()[buf.func_150792_a()];
        String password = buf.func_150789_c(256);
        if (network.getPlayerAccess((PlayerEntity)player).canEdit()) {
            if (!network.getNetworkName().equals(name)) {
                network.setNetworkName(name);
            }
            if (network.getNetworkColor() != color) {
                network.setNetworkColor(color);
                network.getConnections(FluxLogicType.ANY).forEach(device -> {
                    if (device instanceof TileFluxDevice) {
                        ((TileFluxDevice)device).sendFullUpdatePacket();
                    }
                });
            }
            if (FluxUtils.isLegalPassword(password)) {
                network.getSecurity().set(security, password);
            } else {
                S2CNetMsg.feedback(FeedbackInfo.ILLEGAL_PASSWORD, player);
            }
            S2CNetMsg.updateNetwork(network, 21).sendToPlayer(player);
            S2CNetMsg.feedback(FeedbackInfo.SUCCESS_2, player);
        } else {
            S2CNetMsg.feedback(FeedbackInfo.NO_ADMIN, player);
        }
    }

    private static void editWireless(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        IFluxNetwork network = FluxNetworkData.getNetwork(buf.func_150792_a());
        if (!network.isValid()) {
            return;
        }
        if (network.getPlayerAccess((PlayerEntity)player).canEdit()) {
            network.setWirelessMode(buf.func_150792_a());
            S2CNetMsg.updateNetwork(network, 21).sendToPlayer(player);
            S2CNetMsg.feedback(FeedbackInfo.SUCCESS, player);
        } else {
            S2CNetMsg.feedback(FeedbackInfo.NO_ADMIN, player);
        }
    }

    private static void responseNetworkUpdate(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        int type = buf.func_150792_a();
        int size = buf.func_150792_a();
        ArrayList<IFluxNetwork> networks = new ArrayList<IFluxNetwork>();
        for (int i = 0; i < size; ++i) {
            IFluxNetwork network = FluxNetworkData.getNetwork(buf.func_150792_a());
            if (!network.isValid()) continue;
            networks.add(network);
        }
        if (!networks.isEmpty()) {
            S2CNetMsg.updateNetwork(networks, type).sendToPlayer(player);
        }
    }

    private static void setNetwork(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        TileEntity tile = player.field_70170_p.func_175625_s(buf.func_179259_c());
        if (!(tile instanceof TileFluxDevice)) {
            return;
        }
        TileFluxDevice flux = (TileFluxDevice)tile;
        int networkID = buf.func_150792_a();
        if (flux.getNetworkID() == networkID) {
            return;
        }
        IFluxNetwork network = FluxNetworkData.getNetwork(networkID);
        if (network.isValid() && flux.getDeviceType().isController() && !network.getConnections(FluxLogicType.CONTROLLER).isEmpty()) {
            S2CNetMsg.feedback(FeedbackInfo.HAS_CONTROLLER, player);
        } else {
            if (network.isValid() && S2CNetMsg.noAccess(buf.func_150789_c(256), player, network)) {
                return;
            }
            if (network.isValid()) {
                flux.setConnectionOwner(PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()));
            }
            flux.connect(network);
            S2CNetMsg.feedback(FeedbackInfo.SUCCESS, player);
        }
    }

    private static boolean noAccess(String password, ServerPlayerEntity player, @Nonnull IFluxNetwork network) {
        if (!network.getPlayerAccess((PlayerEntity)player).canUse()) {
            if (network.getSecurity().getType() == SecurityType.PRIVATE) {
                S2CNetMsg.feedback(FeedbackInfo.REJECT, player);
                return true;
            }
            if (password.isEmpty()) {
                S2CNetMsg.feedback(FeedbackInfo.PASSWORD_REQUIRE, player);
                return true;
            }
            if (!password.equals(network.getSecurity().getPassword())) {
                S2CNetMsg.feedback(FeedbackInfo.REJECT, player);
                return true;
            }
        }
        return false;
    }

    private static void createNetwork(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        String name = buf.func_150789_c(256);
        int color = buf.readInt();
        SecurityType security = SecurityType.values()[buf.func_150792_a()];
        String password = buf.func_150789_c(256);
        if (FluxUtils.isLegalPassword(password)) {
            if (FluxNetworkData.get().createNetwork((PlayerEntity)player, name, color, security, password) != null) {
                S2CNetMsg.feedback(FeedbackInfo.SUCCESS, player);
            } else {
                S2CNetMsg.feedback(FeedbackInfo.NO_SPACE, player);
            }
        } else {
            S2CNetMsg.feedback(FeedbackInfo.ILLEGAL_PASSWORD, player);
        }
    }

    private static void deleteNetwork(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        IFluxNetwork network = FluxNetworkData.getNetwork(buf.func_150792_a());
        if (network.isValid()) {
            if (network.getPlayerAccess((PlayerEntity)player).canDelete()) {
                FluxNetworkData.get().deleteNetwork(network);
                S2CNetMsg.feedback(FeedbackInfo.SUCCESS, player);
            } else {
                S2CNetMsg.feedback(FeedbackInfo.NO_OWNER, player);
            }
        }
    }

    private static void responseAccessUpdate(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        IFluxNetwork network = FluxNetworkData.getNetwork(buf.func_150792_a());
        AccessLevel access = network.getPlayerAccess((PlayerEntity)player);
        S2CNetMsg.updateAccess(access, player);
    }

    private static void editConnections(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        IFluxNetwork network = FluxNetworkData.getNetwork(buf.func_150792_a());
        if (!network.isValid()) {
            return;
        }
        if (!network.getPlayerAccess((PlayerEntity)player).canEdit()) {
            S2CNetMsg.feedback(FeedbackInfo.NO_ADMIN, player);
            return;
        }
        int flags = buf.func_150792_a();
        int size = buf.func_150792_a();
        if (size == 0) {
            return;
        }
        ArrayList toEdit = new ArrayList();
        for (int i = 0; i < size; ++i) {
            network.getConnectionByPos(FluxUtils.readGlobalPos(buf)).ifPresent(toEdit::add);
        }
        if (toEdit.isEmpty()) {
            return;
        }
        if ((flags & 0x40) != 0) {
            toEdit.forEach(IFluxDevice::disconnect);
            S2CNetMsg.updateNetwork(network, 23).sendToPlayer(player);
            S2CNetMsg.feedback(FeedbackInfo.SUCCESS_2, player);
        } else {
            boolean editName = (flags & 1) != 0;
            boolean editPriority = (flags & 2) != 0;
            boolean editLimit = (flags & 4) != 0;
            boolean editSurgeMode = (flags & 8) != 0;
            boolean editDisableLimit = (flags & 0x10) != 0;
            boolean editChunkLoading = (flags & 0x20) != 0;
            String name = null;
            int priority = 0;
            long limit = 0L;
            boolean surgeMode = false;
            boolean disableLimit = false;
            boolean chunkLoading = false;
            if (editName) {
                name = buf.func_150789_c(256);
            }
            if (editPriority) {
                priority = buf.readInt();
            }
            if (editLimit) {
                limit = buf.readLong();
            }
            if (editSurgeMode) {
                surgeMode = buf.readBoolean();
            }
            if (editDisableLimit) {
                disableLimit = buf.readBoolean();
            }
            if (editChunkLoading) {
                chunkLoading = buf.readBoolean();
            }
            boolean sendBannedLoading = false;
            for (IFluxDevice d : toEdit) {
                if (!(d instanceof TileFluxDevice)) continue;
                TileFluxDevice t = (TileFluxDevice)d;
                if (editName) {
                    t.setCustomName(name);
                }
                if (editPriority) {
                    t.setPriority(priority);
                }
                if (editLimit) {
                    t.setTransferLimit(limit);
                }
                if (editSurgeMode) {
                    t.setSurgeMode(surgeMode);
                }
                if (editDisableLimit) {
                    t.setDisableLimit(disableLimit);
                }
                if (editChunkLoading && !t.getDeviceType().isStorage()) {
                    if (FluxConfig.enableChunkLoading) {
                        if (chunkLoading && !t.isForcedLoading()) {
                            FluxChunkManager.addChunkLoader(t);
                        } else if (!chunkLoading && t.isForcedLoading()) {
                            FluxChunkManager.removeChunkLoader(t);
                        }
                        t.setForcedLoading(FluxChunkManager.isChunkLoader(t));
                    } else {
                        t.setForcedLoading(false);
                        sendBannedLoading = true;
                    }
                }
                t.sendFullUpdatePacket();
            }
            S2CNetMsg.feedback(FeedbackInfo.SUCCESS, player);
            if (sendBannedLoading) {
                S2CNetMsg.feedback(FeedbackInfo.BANNED_LOADING, player);
            }
        }
    }

    private static void responseConnectionUpdate(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        int networkID = buf.func_150792_a();
        IFluxNetwork network = FluxNetworkData.getNetwork(networkID);
        if (!network.isValid()) {
            return;
        }
        int size = buf.func_150792_a();
        ArrayList<CompoundNBT> tags = new ArrayList<CompoundNBT>();
        for (int i = 0; i < size; ++i) {
            GlobalPos pos = FluxUtils.readGlobalPos(buf);
            network.getConnectionByPos(pos).ifPresent(c -> {
                CompoundNBT tag = new CompoundNBT();
                c.writeCustomNBT(tag, 20);
                tags.add(tag);
            });
        }
        if (!tags.isEmpty()) {
            S2CNetMsg.updateConnection(networkID, tags, player);
        }
    }

    private static void configuratorNet(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        int networkID = buf.func_150792_a();
        IFluxNetwork network = FluxNetworkData.getNetwork(networkID);
        if (network.isValid()) {
            if (S2CNetMsg.noAccess(buf.func_150789_c(256), player, network)) {
                return;
            }
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() == RegistryItems.FLUX_CONFIGURATOR) {
                CompoundNBT configs = stack.func_190925_c("FluxConfig");
                configs.func_74768_a("networkID", networkID);
            }
            S2CNetMsg.feedback(FeedbackInfo.SUCCESS, player);
        }
    }

    private static void configuratorEdit(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        String customName = buf.func_150789_c(256);
        CompoundNBT tag = buf.func_150793_b();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() == RegistryItems.FLUX_CONFIGURATOR) {
            if (tag != null && !tag.isEmpty()) {
                stack.func_77983_a("FluxConfig", (INBT)tag);
            }
            stack.func_200302_a((ITextComponent)new StringTextComponent(customName));
        }
    }

    @FunctionalInterface
    static interface Functor {
        public void f(@Nonnull PacketBuffer var1, @Nonnull ServerPlayerEntity var2);
    }
}

