/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.gui.EnumNavigationTab;
import sonar.fluxnetworks.api.misc.EnergyType;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.ScreenUtils;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabPages;
import sonar.fluxnetworks.client.gui.button.BatchEditButton;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.popup.PopupConnectionEdit;
import sonar.fluxnetworks.common.misc.FluxMenu;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.network.C2SNetMsg;

public class GuiTabConnections
extends GuiTabPages<IFluxDevice> {
    public InvisibleButton redirectButton;
    private final List<BatchEditButton> editButtons = new ArrayList<BatchEditButton>();
    public List<IFluxDevice> batchConnections = new ArrayList<IFluxDevice>();
    public IFluxDevice singleConnection;
    public BatchEditButton clear;
    public BatchEditButton edit;
    public BatchEditButton disconnect;
    private int timer = 3;

    public GuiTabConnections(@Nonnull FluxMenu container, @Nonnull PlayerEntity player) {
        super(container, player);
        this.gridStartX = 15;
        this.gridStartY = 22;
        this.gridHeight = 19;
        this.gridPerPage = 7;
        this.elementHeight = 18;
        this.elementWidth = 146;
        C2SNetMsg.requestNetworkUpdate(this.network, 23);
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_CONNECTION;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.configureNavigationButtons(EnumNavigationTab.TAB_CONNECTION, this.navigationTabs);
        this.editButtons.clear();
        this.buttonLists.add(this.editButtons);
        if (!this.networkValid) {
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTab.TAB_SELECTION.getTranslatedName(), b -> this.switchTab(EnumNavigationTab.TAB_SELECTION));
            this.func_230480_a_((Widget)this.redirectButton);
        } else {
            this.clear = new BatchEditButton(118, 8, 0, FluxTranslate.BATCH_CLEAR_BUTTON.t()).setUnclickable();
            this.edit = new BatchEditButton(132, 8, 1, FluxTranslate.BATCH_EDIT_BUTTON.t()).setUnclickable();
            this.disconnect = new BatchEditButton(146, 8, 2, FluxTranslate.BATCH_DISCONNECT_BUTTON.t()).setUnclickable();
            this.editButtons.add(this.clear);
            this.editButtons.add(this.edit);
            this.editButtons.add(this.disconnect);
        }
        this.refreshPages(Lists.newArrayList(this.network.getAllConnections()));
    }

    @Override
    protected void onElementClicked(IFluxDevice element, int mouseButton) {
        if (mouseButton == 0 && this.batchConnections.size() == 0 && element.isChunkLoaded()) {
            this.singleConnection = element;
            this.openPopUp(new PopupConnectionEdit(this, this.player, false));
        }
        if (mouseButton == 1 || mouseButton == 0 && this.batchConnections.size() > 0) {
            if (this.batchConnections.contains(element)) {
                this.batchConnections.remove(element);
                if (this.batchConnections.size() <= 0) {
                    this.clear.clickable = false;
                    this.edit.clickable = false;
                    this.disconnect.clickable = false;
                }
            } else if (element.isChunkLoaded()) {
                this.batchConnections.add(element);
                this.clear.clickable = true;
                this.edit.clickable = true;
                this.disconnect.clickable = true;
            }
        }
    }

    @Override
    protected void drawForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.networkValid) {
            if (this.batchConnections.size() > 0) {
                this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.SELECTED.t() + ": " + TextFormatting.AQUA + this.batchConnections.size(), 20.0f, 10.0f, 0xFFFFFF);
            } else {
                this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.SORT_BY.t() + ": " + TextFormatting.AQUA + FluxTranslate.SORTING_SMART.t(), 19.0f, 10.0f, 0xFFFFFF);
            }
            super.drawForegroundLayer(matrixStack, mouseX, mouseY);
            if (!this.hasActivePopup()) {
                this.drawCenterText(matrixStack, FluxClientCache.getFeedbackText(), 88.0f, 165.0f, FluxClientCache.getFeedbackColor());
            }
        } else {
            super.drawForegroundLayer(matrixStack, mouseX, mouseY);
            this.renderNavigationPrompt(matrixStack, FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    public void renderElement(MatrixStack matrixStack, @Nonnull IFluxDevice element, int x, int y) {
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(ScreenUtils.GUI_BAR);
        int fontColor = 0xFFFFFF;
        int color = element.getDeviceType().color;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        if (this.batchConnections.size() > 0) {
            if (this.batchConnections.contains(element)) {
                GuiTabConnections.func_238467_a_((MatrixStack)matrixStack, (int)(x - 5), (int)(y + 1), (int)(x - 3), (int)(y + this.elementHeight - 1), (int)-855638017);
                GuiTabConnections.func_238467_a_((MatrixStack)matrixStack, (int)(x + this.elementWidth + 3), (int)(y + 1), (int)(x + this.elementWidth + 5), (int)(y + this.elementHeight - 1), (int)-855638017);
                RenderSystem.color3f((float)red, (float)green, (float)blue);
                this.func_238474_b_(matrixStack, x, y, 0, 32, this.elementWidth, this.elementHeight);
            } else {
                GuiTabConnections.func_238467_a_((MatrixStack)matrixStack, (int)(x - 5), (int)(y + 1), (int)(x - 3), (int)(y + this.elementHeight - 1), (int)-1436524448);
                GuiTabConnections.func_238467_a_((MatrixStack)matrixStack, (int)(x + this.elementWidth + 3), (int)(y + 1), (int)(x + this.elementWidth + 5), (int)(y + this.elementHeight - 1), (int)-1436524448);
                RenderSystem.color3f((float)(red * 0.5f), (float)(green * 0.5f), (float)(blue * 0.5f));
                this.func_238474_b_(matrixStack, x, y, 0, 32, this.elementWidth, this.elementHeight);
                fontColor = 0xD0D0D0;
            }
        } else {
            RenderSystem.color3f((float)red, (float)green, (float)blue);
            this.func_238474_b_(matrixStack, x, y, 0, 32, this.elementWidth, this.elementHeight);
        }
        if (element.isChunkLoaded()) {
            this.field_230712_o_.func_238421_b_(matrixStack, element.getCustomName(), (float)(x + 21), (float)(y + 2), fontColor);
            RenderSystem.scaled((double)0.625, (double)0.625, (double)0.625);
            this.field_230712_o_.func_238421_b_(matrixStack, FluxUtils.getTransferInfo(element, EnergyType.FE), (float)(x + 21) * 1.6f, (float)(y + 11) * 1.6f, fontColor);
            RenderSystem.scaled((double)1.6, (double)1.6, (double)1.6);
        } else {
            this.field_230712_o_.func_238421_b_(matrixStack, element.getCustomName(), (float)(x + 21), (float)(y + 5), 0x808080);
        }
        this.screenUtils.renderItemStack(element.getDisplayStack(), x + 2, y + 1);
    }

    @Override
    public void renderElementTooltip(MatrixStack matrixStack, IFluxDevice element, int mouseX, int mouseY) {
        if (!this.hasActivePopup()) {
            this.screenUtils.drawHoverTooltip(matrixStack, this.getFluxInfo(element), mouseX + 4, mouseY - 16);
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (button instanceof BatchEditButton) {
            switch (button.id) {
                case 0: {
                    this.batchConnections.clear();
                    this.clear.clickable = false;
                    this.edit.clickable = false;
                    this.disconnect.clickable = false;
                    break;
                }
                case 1: {
                    this.openPopUp(new PopupConnectionEdit(this, this.player, true));
                    break;
                }
                case 2: {
                    List<GlobalPos> list = this.batchConnections.stream().map(IFluxDevice::getGlobalPos).collect(Collectors.toList());
                    C2SNetMsg.disconnect(this.network.getNetworkID(), list);
                }
            }
        }
    }

    @Override
    public void onFeedbackAction(@Nonnull FeedbackInfo info) {
        super.onFeedbackAction(info);
        if (info == FeedbackInfo.SUCCESS) {
            this.closePopUp();
            this.batchConnections.clear();
            this.clear.clickable = false;
            this.edit.clickable = false;
            this.disconnect.clickable = false;
            this.refreshPages(Lists.newArrayList(this.network.getAllConnections()));
        } else if (info == FeedbackInfo.SUCCESS_2) {
            this.closePopUp();
            if (((FluxMenu)this.field_147002_h).bridge instanceof IFluxDevice) {
                GlobalPos p = ((IFluxDevice)((FluxMenu)this.field_147002_h).bridge).getGlobalPos();
                if (this.batchConnections.stream().anyMatch(f -> f.getGlobalPos().equals((Object)p))) {
                    this.switchTab(EnumNavigationTab.TAB_SELECTION);
                    return;
                }
            }
            this.elements.removeAll(this.batchConnections);
            this.batchConnections.clear();
            this.clear.clickable = false;
            this.edit.clickable = false;
            this.disconnect.clickable = false;
            this.refreshPages(Lists.newArrayList(this.network.getAllConnections()));
            this.page = Math.min(this.page, this.pages);
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (!this.networkValid) {
            return;
        }
        if (this.timer == 4 || this.timer == 14) {
            this.refreshPages(Lists.newArrayList(this.network.getAllConnections()));
        }
        if (this.timer % 5 == 0) {
            C2SNetMsg.requestConnectionUpdate(this.network.getNetworkID(), this.current.stream().map(IFluxDevice::getGlobalPos).collect(Collectors.toList()));
        }
        ++this.timer;
        this.timer %= 20;
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        Comparator<IFluxDevice> comparator = Comparator.comparing(f -> !f.isChunkLoaded()).thenComparing(f -> f.getDeviceType().isStorage()).thenComparing(f -> f.getDeviceType().isPlug()).thenComparing(f -> f.getDeviceType().isPoint()).thenComparingInt(p -> -p.getRawPriority());
        this.elements.sort(comparator);
        this.refreshCurrentPageInternal();
    }
}

