/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.network;

import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import sonar.fluxnetworks.api.device.IFluxController;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.device.IFluxPlug;
import sonar.fluxnetworks.api.device.IFluxPoint;
import sonar.fluxnetworks.api.device.IFluxStorage;

public enum FluxLogicType {
    ANY(IFluxDevice.class),
    PLUG(IFluxPlug.class),
    POINT(IFluxPoint.class),
    STORAGE(IFluxStorage.class),
    CONTROLLER(IFluxController.class);

    private final Class<? extends IFluxDevice> clazz;

    private FluxLogicType(Class<? extends IFluxDevice> clazz) {
        this.clazz = clazz;
    }

    @Nonnull
    public static Set<FluxLogicType> getValidTypes(IFluxDevice tile) {
        EnumSet<FluxLogicType> valid = EnumSet.noneOf(FluxLogicType.class);
        for (FluxLogicType type : FluxLogicType.values()) {
            if (!type.clazz.isInstance(tile)) continue;
            valid.add(type);
        }
        return valid;
    }
}

