/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.tile;

import com.buuz135.industrial.block.transportstorage.tile.BHTile;
import com.buuz135.industrial.gui.component.BigItemGuiAddon;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.NumberUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.client.screen.addon.BasicButtonAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.filter.ItemStackFilter;
import com.hrznstudio.titanium.util.AssetUtil;
import com.hrznstudio.titanium.util.LangUtil;
import com.hrznstudio.titanium.util.RayTraceUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlackHoleUnitTile
extends BHTile<BlackHoleUnitTile> {
    private static HashMap<UUID, Long> INTERACTION_LOGGER = new HashMap();
    @Save
    private ItemStack blStack = ItemStack.field_190927_a;
    @Save
    private int stored = 0;
    @Save
    private ItemStackFilter filter;
    @Save
    private boolean voidItems = true;
    @Save
    private boolean useStackDisplay = false;
    @Save
    private boolean hasNBT = false;
    private BlackHoleHandler handler;
    private final LazyOptional<IItemHandler> lazyStorage;

    public BlackHoleUnitTile(BasicTileBlock<BlackHoleUnitTile> basicTileBlock, Rarity rarity) {
        super(basicTileBlock);
        this.handler = new BlackHoleHandler(BlockUtils.getStackAmountByRarity(rarity));
        this.lazyStorage = LazyOptional.of(() -> this.handler);
        this.filter = new ItemStackFilter("filter", 1);
        this.addFilter((IFilter)this.filter);
        FilterSlot slot = new FilterSlot(79, 60, 0, (Object)ItemStack.field_190927_a);
        slot.setColor(DyeColor.CYAN);
        this.filter.setFilter(0, slot);
        this.addGuiAddonFactory(() -> new BigItemGuiAddon(79, 25){

            @Override
            public ItemStack getItemStack() {
                return BlackHoleUnitTile.this.blStack;
            }

            @Override
            public int getAmount() {
                return BlackHoleUnitTile.this.stored;
            }

            @Override
            public String getAmountDisplay() {
                return BlackHoleUnitTile.this.getFormatedDisplayAmount();
            }
        });
        this.addButton(new ButtonComponent(122, 80, 18, 18){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new BasicButtonAddon(this){

                    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        AssetUtil.drawAsset((MatrixStack)stack, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
                        Minecraft.func_71410_x().func_175599_af().func_175042_a(new ItemStack((IItemProvider)(BlackHoleUnitTile.this.voidItems ? Items.field_151064_bs : Items.field_151123_aH)), guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                        RenderHelper.func_74518_a();
                        RenderSystem.enableAlphaTest();
                    }

                    public List<ITextComponent> getTooltipLines() {
                        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>();
                        lines.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + LangUtil.getString((String)("tooltip.industrialforegoing.bl." + (BlackHoleUnitTile.this.voidItems ? "void_unit" : "no_void_unit")), (Object[])new Object[0])));
                        return lines;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.voidItems = !this.voidItems;
            this.syncObject(this.voidItems);
        }));
        this.addButton(new ButtonComponent(102, 80, 18, 18){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new BasicButtonAddon(this){

                    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        AssetUtil.drawAsset((MatrixStack)stack, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
                        Minecraft.func_71410_x().func_175599_af().func_175042_a(new ItemStack((IItemProvider)(BlackHoleUnitTile.this.useStackDisplay ? Items.field_221698_bk : Items.field_151042_j)), guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                        RenderHelper.func_74518_a();
                        RenderSystem.enableAlphaTest();
                    }

                    public List<ITextComponent> getTooltipLines() {
                        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>();
                        lines.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + LangUtil.getString((String)("tooltip.industrialforegoing.bl." + (BlackHoleUnitTile.this.useStackDisplay ? "stack_unit" : "compact_unit")), (Object[])new Object[0])));
                        return lines;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.useStackDisplay = !this.useStackDisplay;
            this.syncObject(this.useStackDisplay);
        }));
    }

    @Nonnull
    public BlackHoleUnitTile getSelf() {
        return this;
    }

    public ActionResultType onActivated(PlayerEntity playerIn, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        if (playerIn.func_225608_bj_()) {
            this.openGui(playerIn);
        } else if (facing.equals((Object)this.getFacingDirection())) {
            ItemStack stack = playerIn.func_184586_b(hand);
            if (!stack.func_190926_b() && this.handler.isItemValid(0, stack)) {
                playerIn.func_184611_a(hand, this.handler.insertItem(0, stack, false));
            } else if (System.currentTimeMillis() - INTERACTION_LOGGER.getOrDefault(playerIn.func_110124_au(), System.currentTimeMillis()) < 300L) {
                for (ItemStack itemStack : playerIn.field_71071_by.field_70462_a) {
                    if (itemStack.func_190926_b() || !this.handler.insertItem(0, itemStack, true).func_190926_b()) continue;
                    this.handler.insertItem(0, itemStack.func_77946_l(), false);
                    itemStack.func_190920_e(0);
                }
            }
            INTERACTION_LOGGER.put(playerIn.func_110124_au(), System.currentTimeMillis());
        }
        return ActionResultType.SUCCESS;
    }

    public void onClicked(PlayerEntity playerIn) {
        BlockRayTraceResult blockResult;
        Direction facing;
        RayTraceResult rayTraceResult;
        if (this.isServer() && (rayTraceResult = RayTraceUtils.rayTraceSimple((World)this.field_145850_b, (LivingEntity)playerIn, (double)16.0, (float)0.0f)).func_216346_c() == RayTraceResult.Type.BLOCK && (facing = (blockResult = (BlockRayTraceResult)rayTraceResult).func_216354_b()).equals((Object)this.getFacingDirection())) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerIn, (ItemStack)this.handler.extractItem(0, playerIn.func_225608_bj_() ? 64 : 1, false));
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isServer() && !this.hasNBT && this.blStack.func_77942_o()) {
            ItemStack stack = this.blStack.func_77946_l();
            stack.func_77982_d(null);
            this.setStack(stack);
        }
    }

    public void setAmount(int amount) {
        boolean equal = amount == this.stored;
        this.stored = amount;
        if (!equal) {
            this.syncObject(this.stored);
        }
    }

    public void setStack(ItemStack stack) {
        boolean equal = this.blStack.func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)this.blStack, (ItemStack)stack);
        this.blStack = stack;
        this.hasNBT = this.blStack.func_77942_o();
        if (!equal) {
            this.syncObject(this.blStack);
        }
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.blStack;
    }

    @Override
    public String getFormatedDisplayAmount() {
        if (this.useStackDisplay) {
            return this.stored == 0 ? "0" : (this.stored >= 64 ? NumberUtils.getFormatedBigNumber(this.stored / 64) + " x64" : "") + (this.stored >= 64 && this.stored % 64 != 0 ? " + " : "") + (this.stored % 64 != 0 ? Integer.valueOf(this.stored % 64) : "");
        }
        return NumberUtils.getFormatedBigNumber(this.stored);
    }

    private class BlackHoleHandler
    implements IItemHandler {
        private int amount;

        public BlackHoleHandler(int amount) {
            this.amount = amount;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            ItemStack copied = BlackHoleUnitTile.this.blStack.func_77946_l();
            copied.func_190920_e(BlackHoleUnitTile.this.stored);
            return copied;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.isItemValid(slot, stack)) {
                int inserted = Math.min(this.amount - BlackHoleUnitTile.this.stored, stack.func_190916_E());
                if (!simulate) {
                    BlackHoleUnitTile.this.setStack(stack);
                    BlackHoleUnitTile.this.setAmount(Math.min(BlackHoleUnitTile.this.stored + inserted, this.amount));
                }
                if (inserted == stack.func_190916_E() || BlackHoleUnitTile.this.voidItems) {
                    return ItemStack.field_190927_a;
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - inserted));
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.field_190927_a;
            }
            if (BlackHoleUnitTile.this.blStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (BlackHoleUnitTile.this.stored <= amount) {
                ItemStack out = BlackHoleUnitTile.this.blStack.func_77946_l();
                int newAmount = BlackHoleUnitTile.this.stored;
                if (!simulate) {
                    BlackHoleUnitTile.this.setStack(ItemStack.field_190927_a);
                    BlackHoleUnitTile.this.setAmount(0);
                }
                out.func_190920_e(newAmount);
                return out;
            }
            if (!simulate) {
                BlackHoleUnitTile.this.setAmount(BlackHoleUnitTile.this.stored - amount);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)BlackHoleUnitTile.this.blStack, (int)amount);
        }

        public int getSlotLimit(int slot) {
            return this.amount;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                ItemStack filterStack;
                ItemStack fl = BlackHoleUnitTile.this.blStack;
                if (!((ItemStack)BlackHoleUnitTile.this.filter.getFilterSlots()[slot].getFilter()).func_190926_b() && (filterStack = (ItemStack)BlackHoleUnitTile.this.filter.getFilterSlots()[slot].getFilter()).func_77969_a(fl) && ItemStack.func_77970_a((ItemStack)filterStack, (ItemStack)fl)) {
                    fl = (ItemStack)BlackHoleUnitTile.this.filter.getFilterSlots()[slot].getFilter();
                }
                return fl.func_190926_b() || fl.func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)fl, (ItemStack)stack);
            }
            return false;
        }
    }
}

