/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.conveyor;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.block.transportstorage.ConveyorBlock;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.FilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.TextGuiComponent;
import com.buuz135.industrial.gui.component.custom.TextureGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class ConveyorBlinkingUpgrade
extends ConveyorUpgrade {
    public static VoxelShape BB = VoxelShapes.func_197873_a((double)0.1875, (double)0.0625, (double)0.1875, (double)0.8125, (double)0.075, (double)0.8125);
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 3, 3);
    private boolean whitelist = false;
    private int verticalDisplacement = 0;
    private int horizontalDisplacement = 1;

    public ConveyorBlinkingUpgrade(IBlockContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
    }

    @Override
    public void handleEntity(Entity entity) {
        super.handleEntity(entity);
        if (this.whitelist != this.filter.matches(entity)) {
            return;
        }
        Direction direction = (Direction)this.getContainer().getBlockWorld().func_180495_p(this.getContainer().getBlockPosition()).func_177229_b((Property)ConveyorBlock.FACING);
        Vector3d vec3d = new Vector3d((double)(this.horizontalDisplacement * direction.func_176730_m().func_177958_n()), (double)this.verticalDisplacement, (double)(this.horizontalDisplacement * direction.func_176730_m().func_177952_p()));
        BlockPos pos = this.getPos().func_177963_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5);
        this.getWorld().func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187544_ad, SoundCategory.AMBIENT, 0.5f, 1.0f);
    }

    @Override
    public VoxelShape getBoundingBox() {
        return BB;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT() == null ? new CompoundNBT() : super.serializeNBT();
        compound.func_218657_a("Filter", (INBT)this.filter.serializeNBT());
        compound.func_74757_a("Whitelist", this.whitelist);
        compound.func_74780_a("VerticalDisplacement", (double)this.verticalDisplacement);
        compound.func_74780_a("HorizontalDisplacement", (double)this.horizontalDisplacement);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b("Filter")) {
            this.filter.deserializeNBT(nbt.func_74775_l("Filter"));
        }
        this.whitelist = nbt.func_74767_n("Whitelist");
        this.horizontalDisplacement = nbt.func_74762_e("HorizontalDisplacement");
        this.verticalDisplacement = nbt.func_74762_e("VerticalDisplacement");
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean ignoresCollision() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundNBT compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, ItemStack.func_199557_a((CompoundNBT)compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 10) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
        if (buttonId == 11 && this.horizontalDisplacement < 8) {
            ++this.horizontalDisplacement;
            this.getContainer().requestSync();
        }
        if (buttonId == 12 && this.horizontalDisplacement > 1) {
            --this.horizontalDisplacement;
            this.getContainer().requestSync();
        }
        if (buttonId == 13 && this.verticalDisplacement < 8) {
            ++this.verticalDisplacement;
            this.getContainer().requestSync();
        }
        if (buttonId == 14 && this.verticalDisplacement > -8) {
            --this.verticalDisplacement;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorBlinkingUpgrade.this.filter;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(10, 80, 19, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorBlinkingUpgrade.this.whitelist ? 0 : 1;
            }
        });
        componentList.add(new TextureGuiComponent(80, 40, 16, 16, res, 2, 234, "distance_horizontal"));
        componentList.add(new TextureGuiComponent(80, 56, 16, 16, res, 21, 234, "distance_vertical"));
        componentList.add(new TextGuiComponent(104, 44){

            @Override
            public String getText() {
                return TextFormatting.DARK_GRAY + " " + ConveyorBlinkingUpgrade.this.horizontalDisplacement;
            }
        });
        componentList.add(new TextGuiComponent(104, 61){

            @Override
            public String getText() {
                return TextFormatting.DARK_GRAY + (ConveyorBlinkingUpgrade.this.verticalDisplacement >= 0 ? " " : "") + ConveyorBlinkingUpgrade.this.verticalDisplacement;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(11, 130, 40, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 104, new String[]{"increase"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(12, 146, 40, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 16, 104, new String[]{"decrease"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(13, 130, 56, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 104, new String[]{"increase"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(14, 146, 56, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 16, 104, new String[]{"decrease"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            this.setRegistryName("blinking");
        }

        @Override
        public ConveyorUpgrade create(IBlockContainer container, Direction face) {
            return new ConveyorBlinkingUpgrade(container, this, face);
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Collections.singleton(new ResourceLocation("industrialforegoing", "blocks/conveyor_blinking_upgrade"));
        }

        @Override
        @Nonnull
        public Set<Direction> getValidFacings() {
            return DOWN;
        }

        @Override
        public Direction getSideForPlacement(World world, BlockPos pos, PlayerEntity player) {
            return Direction.DOWN;
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_blinking");
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_blinking_upgrade");
        }

        public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((IItemProvider)this.getUpgradeItem()).func_200472_a("IPI").func_200472_a("IDI").func_200472_a("ICI").func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_185161_cS).func_200462_a(Character.valueOf('D'), (IItemProvider)Blocks.field_150331_J).func_200462_a(Character.valueOf('C'), (IItemProvider)ModuleTransportStorage.CONVEYOR).func_200464_a(consumer);
        }
    }
}

