/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.SlaughterFactoryConfig;
import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SlaughterFactoryTile
extends IndustrialAreaWorkingTile<SlaughterFactoryTile> {
    private int maxProgress;
    private int powerPerOperation;
    @Save
    private SidedFluidTankComponent<SlaughterFactoryTile> meat = (SidedFluidTankComponent)new SidedFluidTankComponent("meat", SlaughterFactoryConfig.maxMeatTankSize, 43, 20, 0).setColor(DyeColor.BROWN).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.MEAT.getSourceFluid()));
    @Save
    private SidedFluidTankComponent<SlaughterFactoryTile> pinkSlime;

    public SlaughterFactoryTile() {
        super(ModuleAgricultureHusbandry.SLAUGHTER_FACTORY, RangeManager.RangeType.BEHIND, true, SlaughterFactoryConfig.powerPerOperation);
        this.addTank(this.meat);
        this.pinkSlime = (SidedFluidTankComponent)new SidedFluidTankComponent("pink_slime", SlaughterFactoryConfig.maxPinkSlimeTankSize, 63, 20, 1).setColor(DyeColor.PINK).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.PINK_SLIME.getSourceFluid()));
        this.addTank(this.pinkSlime);
        this.maxProgress = SlaughterFactoryConfig.maxProgress;
        this.powerPerOperation = SlaughterFactoryConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        List mobs;
        if (this.hasEnergy(this.powerPerOperation) && (mobs = this.field_145850_b.func_217357_a(MobEntity.class, this.getWorkingArea().func_197752_a()).stream().filter(LivingEntity::func_70089_S).collect(Collectors.toList())).size() > 0) {
            MobEntity entity = (MobEntity)mobs.get(0);
            float currentHealth = entity.func_110143_aJ();
            entity.remove(true);
            if (!entity.func_70089_S()) {
                this.meat.fillForced(new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid(), entity instanceof AnimalEntity ? (int)currentHealth : (int)currentHealth * 20), IFluidHandler.FluidAction.EXECUTE);
                this.pinkSlime.fillForced(new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid(), entity instanceof AnimalEntity ? (int)(currentHealth * 20.0f) : (int)currentHealth), IFluidHandler.FluidAction.EXECUTE);
                return new IndustrialWorkingTile.WorkAction(this, 0.2f, this.powerPerOperation);
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<SlaughterFactoryTile> createEnergyStorage() {
        return new EnergyStorageComponent(SlaughterFactoryConfig.maxStoredPower, 10, 20);
    }

    @Override
    public VoxelShape getWorkingArea() {
        return new RangeManager(this.field_174879_c, this.getFacingDirection(), RangeManager.RangeType.BEHIND){

            @Override
            public AxisAlignedBB getBox() {
                return super.getBox().func_72321_a(0.0, 2.0, 0.0);
            }
        }.get(this.hasAugmentInstalled(RangeAddonItem.RANGE) ? (int)AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(RangeAddonItem.RANGE).get(0)), (IAugmentType)RangeAddonItem.RANGE) + 1 : 0);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public SlaughterFactoryTile getSelf() {
        return this;
    }
}

