/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets.packets.magnet;

import com.supermartijn642.simplemagnets.ClientProxy;
import java.lang.reflect.Field;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketItemInfo {
    private static final Field PICKUP_DELAY = ObfuscationReflectionHelper.findField(ItemEntity.class, (String)"field_145804_b");
    private int target;
    private UUID thrower;
    private int pickupDelay;

    public PacketItemInfo(ItemEntity itemEntity) {
        this.target = itemEntity.func_145782_y();
        this.thrower = itemEntity.func_200214_m();
        try {
            PICKUP_DELAY.setAccessible(true);
            this.pickupDelay = PICKUP_DELAY.getInt(itemEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PacketItemInfo(int target, UUID thrower, int pickupDelay) {
        this.target = target;
        this.thrower = thrower;
        this.pickupDelay = pickupDelay;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.target);
        buffer.func_179252_a(this.thrower);
        buffer.writeInt(this.pickupDelay);
    }

    public static PacketItemInfo decode(PacketBuffer buffer) {
        return new PacketItemInfo(buffer.readInt(), buffer.func_179253_g(), buffer.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().setPacketHandled(true);
        PlayerEntity player = ClientProxy.getPlayer();
        if (player != null && player.field_70170_p != null) {
            contextSupplier.get().enqueueWork(() -> {
                Entity entity = player.field_70170_p.func_73045_a(this.target);
                if (entity instanceof ItemEntity) {
                    ((ItemEntity)entity).func_200216_c(this.thrower);
                    ((ItemEntity)entity).func_174867_a(this.pickupDelay);
                }
            });
        }
    }
}

