/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.supermartijn642.simplemagnets.ItemSpawnHandler;
import com.supermartijn642.simplemagnets.SMConfig;
import com.supermartijn642.simplemagnets.SimpleMagnets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;

public class DemagnetizationCoilTile
extends TileEntity
implements ITickableTileEntity {
    private final int minRange;
    private final int maxRange;
    private final boolean hasFilter;
    public int rangeX;
    public int rangeY;
    public int rangeZ;
    public final List<ItemStack> filter = new ArrayList<ItemStack>(9);
    public boolean filterWhitelist;
    public boolean filterDurability = true;
    private boolean dataChanged;

    public DemagnetizationCoilTile(TileEntityType<?> tileEntityType, int minRange, int maxRange, int range, boolean hasFilter) {
        super(tileEntityType);
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.rangeY = this.rangeZ = range;
        this.rangeX = this.rangeZ;
        this.hasFilter = hasFilter;
        for (int i = 0; i < 9; ++i) {
            this.filter.add(ItemStack.field_190927_a);
        }
    }

    public void func_73660_a() {
        AxisAlignedBB area = this.getArea();
        List affectedItems = this.field_145850_b.func_217394_a(EntityType.field_200765_E, area, item -> item.func_70089_S() && this.shouldEffectItem(item.func_92059_d()));
        affectedItems.forEach(item -> {
            item.getPersistentData().func_74757_a("PreventRemoteMovement", true);
            item.getPersistentData().func_74757_a("AllowMachineRemoteMovement", true);
        });
    }

    public AxisAlignedBB getArea() {
        return new AxisAlignedBB(this.field_174879_c).func_72314_b((double)(this.rangeX - 1), (double)(this.rangeY - 1), (double)(this.rangeZ - 1));
    }

    public boolean shouldEffectItem(ItemStack stack) {
        if (!this.hasFilter) {
            return true;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack filter = this.filter.get(i);
            if (!ItemStack.func_179545_c((ItemStack)filter, (ItemStack)stack) || this.filterDurability && !ItemStack.func_77970_a((ItemStack)filter, (ItemStack)stack)) continue;
            return this.filterWhitelist;
        }
        return !this.filterWhitelist;
    }

    public void setRangeX(int range) {
        int old = this.rangeX;
        this.rangeX = Math.min(Math.max(range, this.minRange), this.maxRange);
        if (this.rangeX != old) {
            this.dataChanged();
        }
    }

    public void setRangeY(int range) {
        int old = this.rangeY;
        this.rangeY = Math.min(Math.max(range, this.minRange), this.maxRange);
        if (this.rangeY != old) {
            this.dataChanged();
        }
    }

    public void setRangeZ(int range) {
        int old = this.rangeZ;
        this.rangeZ = Math.min(Math.max(range, this.minRange), this.maxRange);
        if (this.rangeZ != old) {
            this.dataChanged();
        }
    }

    public void dataChanged() {
        if (!this.field_145850_b.field_72995_K) {
            this.dataChanged = true;
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    private CompoundNBT getChangedData() {
        return this.dataChanged ? this.getData() : null;
    }

    private CompoundNBT getData() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("rangeX", this.rangeX);
        tag.func_74768_a("rangeY", this.rangeY);
        tag.func_74768_a("rangeZ", this.rangeZ);
        if (this.hasFilter) {
            for (int i = 0; i < 9; ++i) {
                if (this.filter.get(i).func_190926_b()) continue;
                tag.func_218657_a("filter" + i, (INBT)this.filter.get(i).func_77955_b(new CompoundNBT()));
            }
            tag.func_74757_a("filterWhitelist", this.filterWhitelist);
            tag.func_74757_a("filterDurability", this.filterDurability);
        }
        return tag;
    }

    private void handleData(CompoundNBT tag) {
        if (tag.func_74764_b("rangeX")) {
            this.rangeX = tag.func_74762_e("rangeX");
        }
        if (tag.func_74764_b("rangeY")) {
            this.rangeY = tag.func_74762_e("rangeY");
        }
        if (tag.func_74764_b("rangeZ")) {
            this.rangeZ = tag.func_74762_e("rangeZ");
        }
        if (this.hasFilter) {
            for (int i = 0; i < 9; ++i) {
                this.filter.set(i, tag.func_74764_b("filter" + i) ? ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("filter" + i)) : ItemStack.field_190927_a);
            }
            this.filterWhitelist = tag.func_74764_b("filterWhitelist") && tag.func_74767_n("filterWhitelist");
            this.filterDurability = tag.func_74764_b("filterDurability") && tag.func_74767_n("filterDurability");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("data", (INBT)this.getData());
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("data")) {
            this.handleData(compound.func_74775_l("data"));
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = this.getChangedData();
        return tag == null || tag.isEmpty() ? null : new SUpdateTileEntityPacket(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleData(pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_218657_a("data", (INBT)this.getData());
        return tag;
    }

    public void onLoad() {
        ItemSpawnHandler.add(this);
    }

    public static class AdvancedDemagnetizationCoilTile
    extends DemagnetizationCoilTile {
        public AdvancedDemagnetizationCoilTile() {
            super(SimpleMagnets.advanced_demagnetization_coil_tile, SMConfig.advancedCoilMinRange.get(), SMConfig.advancedCoilMaxRange.get(), SMConfig.advancedCoilRange.get(), SMConfig.advancedCoilFilter.get());
        }
    }

    public static class BasicDemagnetizationCoilTile
    extends DemagnetizationCoilTile {
        public BasicDemagnetizationCoilTile() {
            super(SimpleMagnets.basic_demagnetization_coil_tile, SMConfig.basicCoilMinRange.get(), SMConfig.basicCoilMaxRange.get(), SMConfig.basicCoilRange.get(), SMConfig.basicCoilFilter.get());
        }
    }
}

