/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.supermartijn642.simplemagnets.DemagnetizationCoilTile;
import com.supermartijn642.simplemagnets.SMConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DemagnetizationCoilAreaHighlighter {
    public static final RenderType RENDER_TYPE;

    @SubscribeEvent
    public static void onDrawHighlight(DrawHighlightEvent.HighlightBlock e) {
        if (!SMConfig.showDemagnetizationArea.get().booleanValue()) {
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = e.getTarget().func_216350_a();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof DemagnetizationCoilTile) {
            MatrixStack matrixStack = e.getMatrix();
            matrixStack.func_227860_a_();
            Vector3d playerPos = e.getInfo().func_216785_c();
            matrixStack.func_227861_a_(-playerPos.field_72450_a, -playerPos.field_72448_b, -playerPos.field_72449_c);
            DemagnetizationCoilAreaHighlighter.drawBoundingBox(matrixStack, e.getBuffers(), pos, (DemagnetizationCoilTile)tile);
            matrixStack.func_227865_b_();
        }
    }

    private static void drawBoundingBox(MatrixStack matrixStack, IRenderTypeBuffer buffer, BlockPos pos, DemagnetizationCoilTile tile) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.disableTexture();
        RenderHelper.func_74518_a();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.depthMask((boolean)true);
        IVertexBuilder builder = buffer.getBuffer(RENDER_TYPE);
        float red = (float)Math.abs(pos.func_177958_n() % 255) / 255.0f;
        float green = (float)Math.abs(pos.func_177956_o() % 255) / 255.0f;
        float blue = (float)Math.abs(pos.func_177952_p() % 255) / 255.0f;
        DemagnetizationCoilAreaHighlighter.renderSides(matrixStack, builder, tile.getArea(), red, green, blue, 0.2f);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    private static void renderSides(MatrixStack stack, IVertexBuilder builder, AxisAlignedBB pos, float red, float green, float blue, float alpha) {
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        float minX = (float)pos.field_72340_a;
        float maxX = (float)pos.field_72336_d;
        float minY = (float)pos.field_72338_b;
        float maxY = (float)pos.field_72337_e;
        float minZ = (float)pos.field_72339_c;
        float maxZ = (float)pos.field_72334_f;
        builder.func_227888_a_(matrix, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    static {
        RenderType.State state = RenderType.State.func_228694_a_().func_228726_a_(new RenderState.TransparencyState("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.enableAlphaTest();
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.disableAlphaTest();
        })).func_228728_a_(true);
        RENDER_TYPE = RenderType.func_228633_a_((String)"demagnetization_coil_highlight", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)state);
    }
}

