/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.gardentools.block.magnet;

import com.lothrazar.gardentools.ConfigManager;
import com.lothrazar.gardentools.GardenRegistry;
import com.lothrazar.gardentools.block.Vector3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.HopperBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.VanillaInventoryCodeHooks;
import org.apache.commons.lang3.tuple.Pair;

public class TileMagnet
extends TileEntity
implements ITickableTileEntity {
    private static final float ITEMSPEEDFAR = 0.8f;
    private static final float ITEMSPEEDCLOSE = 0.08f;
    private static final double ENTITY_PULL_DIST = 0.4;
    private static final double ENTITY_PULL_SPEED_CUTOFF = 3.0;

    public TileMagnet() {
        super(GardenRegistry.MAGNETTILE);
    }

    public void func_73660_a() {
        IItemHandler hopper;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        TileEntity below = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        HashSet<Item> filter = new HashSet<Item>();
        if (below != null && (hopper = (IItemHandler)below.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null)) != null) {
            filter.addAll(this.getItemsInItemHandler(hopper));
            if (below instanceof HopperTileEntity) {
                HopperTileEntity hopperTileEntity = (HopperTileEntity)below;
                filter.addAll(this.getConnectedItemHandlerItems(hopperTileEntity));
            }
        }
        int radius = (Integer)ConfigManager.MAGNET_RANGE.get();
        boolean vradius = false;
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)radius, (double)vradius, (double)radius);
        List list = this.field_145850_b.func_217357_a(ItemEntity.class, axisalignedbb);
        TileMagnet.pullEntityList((double)x + 0.2, (double)y + 0.5, (double)z + 0.2, true, list, filter);
    }

    private List<Item> getConnectedItemHandlerItems(HopperTileEntity hopper) {
        Direction hopperFacing = (Direction)hopper.func_195044_w().func_177229_b((Property)HopperBlock.field_176430_a);
        double x = hopper.func_96107_aA() + (double)hopperFacing.func_82601_c();
        double y = hopper.func_96109_aB() + (double)hopperFacing.func_96559_d();
        double z = hopper.func_96108_aC() + (double)hopperFacing.func_82599_e();
        Optional itemHandlerPair = VanillaInventoryCodeHooks.getItemHandler((World)hopper.func_145831_w(), (double)x, (double)y, (double)z, (Direction)hopperFacing.func_176734_d());
        if (!itemHandlerPair.isPresent()) {
            return Collections.emptyList();
        }
        IItemHandler itemHandler = (IItemHandler)((Pair)itemHandlerPair.get()).getKey();
        return this.getItemsInItemHandler(itemHandler);
    }

    public static int pullEntityList(double x, double y, double z, boolean towardsPos, List<ItemEntity> all, Set<Item> filter) {
        int moved = 0;
        int direction = towardsPos ? 1 : -1;
        for (ItemEntity entity : all) {
            double zDist;
            BlockPos p;
            double xDist;
            double hdist;
            if (entity == null || filter != null && !filter.isEmpty() && !filter.contains(entity.func_92059_d().func_77973_b()) || !((hdist = Math.sqrt((xDist = Math.abs(x - (double)(p = entity.func_233580_cy_()).func_177958_n())) * xDist + (zDist = Math.abs(z - (double)p.func_177952_p())) * zDist)) > 0.4)) continue;
            float speed = hdist > 3.0 ? 0.8f : 0.08f;
            TileMagnet.setEntityMotionFromVector((Entity)entity, x, y, z, (float)direction * speed);
            ++moved;
        }
        return moved;
    }

    public static void setEntityMotionFromVector(Entity entity, double x, double y, double z, float modifier) {
        Vector3 originalPosVector = new Vector3(x, y, z);
        Vector3 entityVector = new Vector3(entity);
        Vector3 finalVector = originalPosVector.copy().subtract(entityVector);
        if (finalVector.mag() > 1.0) {
            finalVector.normalize();
        }
        double motionX = finalVector.x * (double)modifier;
        double motionY = finalVector.y * (double)modifier;
        double motionZ = finalVector.z * (double)modifier;
        entity.func_213293_j(motionX, motionY, motionZ);
    }

    private List<Item> getItemsInItemHandler(IItemHandler itemHandler) {
        ArrayList<Item> filter = new ArrayList<Item>();
        if (itemHandler == null) {
            return filter;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            filter.add(stack.func_77973_b());
        }
        return filter;
    }
}

