/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.BaseTier;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.DynamicHandler;
import mekanism.common.capabilities.chemical.dynamic.DynamicChemicalHandler;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.resolver.manager.ChemicalHandlerManager;
import mekanism.common.content.network.BoxedChemicalNetwork;
import mekanism.common.content.network.transmitter.BoxedPressurizedTube;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;

public class TileEntityPressurizedTube
extends TileEntityTransmitter {
    private final ChemicalHandlerManager.GasHandlerManager gasHandlerManager;
    private final ChemicalHandlerManager.InfusionHandlerManager infusionHandlerManager;
    private final ChemicalHandlerManager.PigmentHandlerManager pigmentHandlerManager;
    private final ChemicalHandlerManager.SlurryHandlerManager slurryHandlerManager;

    public TileEntityPressurizedTube(IBlockProvider blockProvider) {
        super(blockProvider);
        DynamicHandler.InteractPredicate canExtract = this.getExtractPredicate();
        DynamicHandler.InteractPredicate canInsert = this.getInsertPredicate();
        this.gasHandlerManager = new ChemicalHandlerManager.GasHandlerManager(this.getHolder(BoxedPressurizedTube::getGasTanks), new DynamicChemicalHandler.DynamicGasHandler(this::getGasTanks, canExtract, canInsert, null));
        this.addCapabilityResolver(this.gasHandlerManager);
        this.infusionHandlerManager = new ChemicalHandlerManager.InfusionHandlerManager(this.getHolder(BoxedPressurizedTube::getInfusionTanks), new DynamicChemicalHandler.DynamicInfusionHandler(this::getInfusionTanks, canExtract, canInsert, null));
        this.addCapabilityResolver(this.infusionHandlerManager);
        this.pigmentHandlerManager = new ChemicalHandlerManager.PigmentHandlerManager(this.getHolder(BoxedPressurizedTube::getPigmentTanks), new DynamicChemicalHandler.DynamicPigmentHandler(this::getPigmentTanks, canExtract, canInsert, null));
        this.addCapabilityResolver(this.pigmentHandlerManager);
        this.slurryHandlerManager = new ChemicalHandlerManager.SlurryHandlerManager(this.getHolder(BoxedPressurizedTube::getSlurryTanks), new DynamicChemicalHandler.DynamicSlurryHandler(this::getSlurryTanks, canExtract, canInsert, null));
        this.addCapabilityResolver(this.slurryHandlerManager);
    }

    protected BoxedPressurizedTube createTransmitter(IBlockProvider blockProvider) {
        return new BoxedPressurizedTube(blockProvider, this);
    }

    public BoxedPressurizedTube getTransmitter() {
        return (BoxedPressurizedTube)super.getTransmitter();
    }

    @Override
    public void func_73660_a() {
        if (!this.isRemote()) {
            this.getTransmitter().pullFromAcceptors();
        }
        super.func_73660_a();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.PRESSURIZED_TUBE;
    }

    @Override
    @Nonnull
    protected BlockState upgradeResult(@Nonnull BlockState current, @Nonnull BaseTier tier) {
        switch (tier) {
            case BASIC: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.BASIC_PRESSURIZED_TUBE.getBlock().func_176223_P());
            }
            case ADVANCED: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ADVANCED_PRESSURIZED_TUBE.getBlock().func_176223_P());
            }
            case ELITE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ELITE_PRESSURIZED_TUBE.getBlock().func_176223_P());
            }
            case ULTIMATE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ULTIMATE_PRESSURIZED_TUBE.getBlock().func_176223_P());
            }
        }
        return current;
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            BoxedChemicalNetwork network = (BoxedChemicalNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.func_218657_a("boxedChemical", (INBT)network.lastChemical.write(new CompoundNBT()));
            updateTag.func_74776_a("scale", network.currentScale);
        }
        return updateTag;
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> IChemicalTankHolder<CHEMICAL, STACK, TANK> getHolder(BiFunction<BoxedPressurizedTube, Direction, List<TANK>> tankFunction) {
        BoxedPressurizedTube tube = this.getTransmitter();
        return direction -> {
            if (direction != null && tube.getConnectionTypeRaw(direction) == ConnectionType.NONE) {
                return Collections.emptyList();
            }
            return (List)tankFunction.apply(tube, direction);
        };
    }

    private List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasHandlerManager.getContainers(side);
    }

    private List<IInfusionTank> getInfusionTanks(@Nullable Direction side) {
        return this.infusionHandlerManager.getContainers(side);
    }

    private List<IPigmentTank> getPigmentTanks(@Nullable Direction side) {
        return this.pigmentHandlerManager.getContainers(side);
    }

    private List<ISlurryTank> getSlurryTanks(@Nullable Direction side) {
        return this.slurryHandlerManager.getContainers(side);
    }

    @Override
    public void sideChanged(@Nonnull Direction side, @Nonnull ConnectionType old, @Nonnull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapability(Capabilities.GAS_HANDLER_CAPABILITY, side);
            this.invalidateCapability(Capabilities.INFUSION_HANDLER_CAPABILITY, side);
            this.invalidateCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY, side);
            this.invalidateCapability(Capabilities.SLURRY_HANDLER_CAPABILITY, side);
            WorldUtils.notifyNeighborOfChange(this.field_145850_b, side, this.field_174879_c);
        } else if (old == ConnectionType.NONE) {
            WorldUtils.notifyNeighborOfChange(this.field_145850_b, side, this.field_174879_c);
        }
    }
}

