/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.qio.filter.QIOTagFilter;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityQIOExporter
extends TileEntityQIOFilterHandler {
    private static final int MAX_DELAY = 10;
    private int delay = 0;
    private boolean exportWithoutFilter;
    private final EfficientEjector<Object2LongMap.Entry<HashedItem>> filterEjector = new EfficientEjector(Map.Entry::getKey, e -> (int)Math.min(Integer.MAX_VALUE, e.getLongValue()));
    private final EfficientEjector<Map.Entry<HashedItem, QIOFrequency.QIOItemTypeData>> filterlessEjector = new EfficientEjector(Map.Entry::getKey, e -> (int)Math.min(Integer.MAX_VALUE, ((QIOFrequency.QIOItemTypeData)e.getValue()).getCount()));

    public TileEntityQIOExporter() {
        super(MekanismBlocks.QIO_EXPORTER);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (MekanismUtils.canFunction(this)) {
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            this.tryEject();
            this.delay = 10;
        }
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            QIOFrequency frequency = this.getQIOFrequency();
            this.setActive(frequency != null);
        }
    }

    private void tryEject() {
        QIOFrequency freq = this.getQIOFrequency();
        TileEntity back = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.field_174879_c.func_177972_a(this.getOppositeDirection()));
        if (freq == null || !InventoryUtils.isItemHandler(back, this.getDirection())) {
            return;
        }
        if (!this.exportWithoutFilter && this.getFilters().isEmpty()) {
            return;
        }
        if (this.exportWithoutFilter && this.getFilters().isEmpty()) {
            ((EfficientEjector)this.filterlessEjector).eject(freq, back, freq.getItemDataMap().entrySet());
        } else if (!this.getFilters().isEmpty()) {
            ((EfficientEjector)this.filterEjector).eject(freq, back, (Collection)this.getFilterEjectMap(back, freq).object2LongEntrySet());
        }
    }

    private Object2LongMap<HashedItem> getFilterEjectMap(TileEntity back, QIOFrequency freq) {
        Object2LongOpenHashMap map = new Object2LongOpenHashMap();
        for (QIOFilter<?> filter : this.getFilters()) {
            if (filter instanceof QIOItemStackFilter) {
                HashedItem type = HashedItem.create(((QIOItemStackFilter)filter).getItemStack());
                map.put((Object)type, freq.getStored(type));
                continue;
            }
            if (!(filter instanceof QIOTagFilter)) continue;
            String tagName = ((QIOTagFilter)filter).getTagName();
            map.putAll(freq.getStacksByWildcard(tagName));
        }
        return map;
    }

    public boolean getExportWithoutFilter() {
        return this.exportWithoutFilter;
    }

    public void toggleExportWithoutFilter() {
        this.exportWithoutFilter = !this.exportWithoutFilter;
        this.markDirty(false);
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getExportWithoutFilter, value -> {
            this.exportWithoutFilter = value;
        }));
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        super.writeSustainedData(itemStack);
        ItemDataUtils.setBoolean(itemStack, "auto", this.exportWithoutFilter);
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        super.readSustainedData(itemStack);
        this.exportWithoutFilter = ItemDataUtils.getBoolean(itemStack, "auto");
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Map<String, String> remap = super.getTileDataRemap();
        remap.put("auto", "auto");
        return remap;
    }

    @Override
    public CompoundNBT getConfigurationData(CompoundNBT nbtTags) {
        super.getConfigurationData(nbtTags);
        nbtTags.func_74757_a("auto", this.exportWithoutFilter);
        return nbtTags;
    }

    @Override
    public void setConfigurationData(CompoundNBT nbtTags) {
        super.setConfigurationData(nbtTags);
        NBTUtils.setBooleanIfPresent(nbtTags, "auto", value -> {
            this.exportWithoutFilter = value;
        });
    }

    private final class EfficientEjector<T> {
        private static final int MAX_EJECT_ATTEMPTS = 100;
        private final Function<T, HashedItem> typeSupplier;
        private final ToIntFunction<T> countSupplier;

        private EfficientEjector(Function<T, HashedItem> typeSupplier, ToIntFunction<T> countSupplier) {
            this.typeSupplier = typeSupplier;
            this.countSupplier = countSupplier;
        }

        private void eject(QIOFrequency freq, TileEntity tile, Collection<T> ejectMap) {
            if (ejectMap.isEmpty()) {
                return;
            }
            double ejectChance = Math.min(1.0, 100.0 / (double)ejectMap.size());
            int maxTypes = TileEntityQIOExporter.this.getMaxTransitTypes();
            int maxCount = TileEntityQIOExporter.this.getMaxTransitCount();
            Object2IntOpenHashMap removed = new Object2IntOpenHashMap();
            int amountRemoved = 0;
            Optional capability = CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, TileEntityQIOExporter.this.getDirection()).resolve();
            if (capability.isPresent()) {
                IItemHandler inventory = (IItemHandler)capability.get();
                for (T obj : ejectMap) {
                    if (amountRemoved == maxCount || removed.size() == maxTypes) break;
                    if (TileEntityQIOExporter.this.func_145831_w().func_201674_k().nextDouble() > ejectChance) continue;
                    HashedItem type = this.typeSupplier.apply(obj);
                    ItemStack origInsert = type.createStack(Math.min(maxCount - amountRemoved, this.countSupplier.applyAsInt(obj)));
                    ItemStack toInsert = origInsert.func_77946_l();
                    for (int i = 0; !(i >= inventory.getSlots() || inventory.isItemValid(i, toInsert) && (toInsert = inventory.insertItem(i, toInsert, false)).func_190926_b()); ++i) {
                    }
                    ItemStack toUse = TransporterManager.getToUse(origInsert, toInsert);
                    if (toUse.func_190926_b()) continue;
                    amountRemoved += toUse.func_190916_E();
                    removed.put(type, removed.getOrDefault(type, 0) + toUse.func_190916_E());
                }
            }
            for (Map.Entry entry : removed.entrySet()) {
                ItemStack ret = freq.removeByType((HashedItem)entry.getKey(), (Integer)entry.getValue());
                if (ret.func_190916_E() == ((Integer)entry.getValue()).intValue()) continue;
                Mekanism.logger.error("QIO ejection item removal didn't line up with prediction: removed {}, expected {}", (Object)ret.func_190916_E(), entry.getValue());
            }
        }
    }
}

