/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Upgrade;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.chunkloading.IChunkLoader;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.util.WorldUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileComponentChunkLoader<T extends TileEntityMekanism>
implements ITileComponent {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mekanism TileComponentChunkLoader");
    private final T tile;
    private final LongSet chunkSet = new LongOpenHashSet();
    @Nullable
    private ServerWorld prevWorld;
    @Nullable
    private BlockPos prevPos;
    private boolean hasRegistered;
    @Deprecated
    private boolean isFirstTick = true;

    public TileComponentChunkLoader(T tile) {
        this.tile = tile;
        ((TileEntityMekanism)this.tile).addComponent(this);
    }

    public boolean canOperate() {
        return MekanismConfig.general.allowChunkloading.get() && ((TileEntityMekanism)this.tile).supportsUpgrades() && ((TileEntityMekanism)this.tile).getComponent().isUpgradeInstalled(Upgrade.ANCHOR);
    }

    private void releaseChunkTickets(@Nonnull ServerWorld world, @Nonnull BlockPos pos) {
        int tickets = this.chunkSet.size();
        LOGGER.debug("Attempting to remove {} chunk tickets. Pos: {} World: {}", (Object)tickets, (Object)pos, (Object)world.func_234923_W_().func_240901_a_());
        if (tickets > 0) {
            LongIterator longIterator = this.chunkSet.iterator();
            while (longIterator.hasNext()) {
                long chunkPos = (Long)longIterator.next();
                ForgeChunkManager.forceChunk((ServerWorld)world, (String)"mekanism", (BlockPos)pos, (int)((int)chunkPos), (int)((int)(chunkPos >> 32)), (boolean)false, (boolean)false);
            }
            this.chunkSet.clear();
            this.markDirty();
        }
        this.hasRegistered = false;
        this.prevWorld = null;
    }

    private void registerChunkTickets(@Nonnull ServerWorld world) {
        this.prevPos = this.tile.func_174877_v();
        this.prevWorld = world;
        Set<ChunkPos> chunks = ((IChunkLoader)this.tile).getChunkSet();
        int tickets = chunks.size();
        LOGGER.debug("Attempting to add {} chunk tickets. Pos: {} World: {}", (Object)tickets, (Object)this.prevPos, (Object)world.func_234923_W_().func_240901_a_());
        if (tickets > 0) {
            for (ChunkPos chunkPos : chunks) {
                ForgeChunkManager.forceChunk((ServerWorld)world, (String)"mekanism", (BlockPos)this.prevPos, (int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b, (boolean)true, (boolean)false);
                this.chunkSet.add(chunkPos.func_201841_a());
            }
            this.markDirty();
        }
        this.hasRegistered = true;
    }

    public void refreshChunkTickets() {
        if (!((TileEntityUpdateable)this.tile).isRemote()) {
            this.refreshChunkTickets((ServerWorld)Objects.requireNonNull(this.tile.func_145831_w()), this.tile.func_174877_v(), true);
        }
    }

    private void refreshChunkTickets(@Nonnull ServerWorld world, @Nonnull BlockPos pos, boolean ticketsChanged) {
        boolean canOperate = this.canOperate();
        if (this.hasRegistered && this.prevWorld != null && this.prevPos != null) {
            if (this.prevWorld != world || !pos.equals((Object)this.prevPos)) {
                this.releaseChunkTickets(this.prevWorld, this.prevPos);
                if (canOperate) {
                    this.registerChunkTickets(world);
                }
            } else if (!canOperate) {
                this.releaseChunkTickets(world, pos);
            } else if (ticketsChanged) {
                if (this.chunkSet.isEmpty()) {
                    this.registerChunkTickets(world);
                } else {
                    LongSet chunks = this.getTileChunks();
                    if (chunks.isEmpty()) {
                        this.releaseChunkTickets(world, pos);
                    } else {
                        int removed = 0;
                        int added = 0;
                        LongIterator chunkIt = this.chunkSet.iterator();
                        while (chunkIt.hasNext()) {
                            long chunkPos = chunkIt.nextLong();
                            if (chunks.contains(chunkPos)) continue;
                            ForgeChunkManager.forceChunk((ServerWorld)world, (String)"mekanism", (BlockPos)pos, (int)((int)chunkPos), (int)((int)(chunkPos >> 32)), (boolean)false, (boolean)false);
                            chunkIt.remove();
                            ++removed;
                        }
                        LongIterator longIterator = chunks.iterator();
                        while (longIterator.hasNext()) {
                            long chunkPos = (Long)longIterator.next();
                            if (!this.chunkSet.add(chunkPos)) continue;
                            ForgeChunkManager.forceChunk((ServerWorld)world, (String)"mekanism", (BlockPos)pos, (int)((int)chunkPos), (int)((int)(chunkPos >> 32)), (boolean)true, (boolean)false);
                            ++added;
                        }
                        if (removed != 0 || added != 0) {
                            this.markDirty();
                        }
                        LOGGER.debug("Removed {} no longer valid chunk tickets, and added {} newly valid chunk tickets. Pos: {} World: {}", (Object)removed, (Object)added, (Object)pos, (Object)world.func_234923_W_().func_240901_a_());
                    }
                }
            }
        } else if (canOperate) {
            this.registerChunkTickets(world);
        }
    }

    @Override
    public void tick() {
        World world = this.tile.func_145831_w();
        if (world != null && !world.field_72995_K) {
            if (this.isFirstTick) {
                this.isFirstTick = false;
                if (!this.canOperate()) {
                    this.releaseChunkTickets((ServerWorld)world, this.tile.func_174877_v());
                }
            }
            this.refreshChunkTickets((ServerWorld)world, this.tile.func_174877_v(), false);
        }
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        if (!this.chunkSet.isEmpty()) {
            if (this.tile.func_145830_o() && !((TileEntityUpdateable)this.tile).isRemote() && this.hasRegistered && this.prevWorld != null && this.prevPos != null) {
                this.releaseChunkTickets(this.prevWorld, this.prevPos);
            } else {
                this.chunkSet.clear();
            }
        }
        if (nbtTags.func_150297_b("chunkSet", 9)) {
            ListNBT list = nbtTags.func_150295_c("chunkSet", 4);
            for (INBT nbt : list) {
                this.chunkSet.add(((LongNBT)nbt).func_150291_c());
            }
        } else {
            for (long chunk : nbtTags.func_197645_o("chunkSet")) {
                this.chunkSet.add(chunk);
            }
        }
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        nbtTags.func_197644_a("chunkSet", this.chunkSet.toLongArray());
    }

    @Override
    public void invalidate() {
        if (!((TileEntityUpdateable)this.tile).isRemote() && this.hasRegistered && this.prevWorld != null && this.prevPos != null) {
            this.releaseChunkTickets(this.prevWorld, this.prevPos);
        }
    }

    @Override
    public void addToUpdateTag(CompoundNBT updateTag) {
    }

    @Override
    public void readFromUpdateTag(CompoundNBT updateTag) {
    }

    private void markDirty() {
        if (this.tile.func_145830_o()) {
            WorldUtils.markChunkDirty(this.tile.func_145831_w(), this.tile.func_174877_v());
        }
    }

    private LongSet getTileChunks() {
        Set<ChunkPos> chunks = ((IChunkLoader)this.tile).getChunkSet();
        if (chunks.isEmpty()) {
            return LongSets.EMPTY_SET;
        }
        LongOpenHashSet chunksAsLongs = new LongOpenHashSet();
        for (ChunkPos chunkPos : chunks) {
            chunksAsLongs.add(chunkPos.func_201841_a());
        }
        return chunksAsLongs;
    }

    public static class ChunkValidationCallback
    implements ForgeChunkManager.LoadingValidationCallback {
        public static final ChunkValidationCallback INSTANCE = new ChunkValidationCallback();

        private ChunkValidationCallback() {
        }

        public void validateTickets(@Nonnull ServerWorld world, @Nonnull ForgeChunkManager.TicketHelper ticketHelper) {
            ResourceLocation worldName = world.func_234923_W_().func_240901_a_();
            LOGGER.debug("Validating tickets for: {}. Blocks: {}, Entities: {}", (Object)worldName, (Object)ticketHelper.getBlockTickets().size(), (Object)ticketHelper.getEntityTickets().size());
            for (Map.Entry entry : ticketHelper.getBlockTickets().entrySet()) {
                BlockPos pos = (BlockPos)entry.getKey();
                LongSet forcedChunks = (LongSet)((Pair)entry.getValue()).getFirst();
                int ticketCount = forcedChunks.size();
                LOGGER.debug("Validating tickets for: {}, BlockPos: {}, Forced chunks: {}, Ticking forced chunks: {}", (Object)worldName, (Object)pos, (Object)ticketCount, (Object)((LongSet)((Pair)entry.getValue()).getSecond()).size());
                if (ticketCount <= 0) continue;
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof IChunkLoader) {
                    TileComponentChunkLoader<?> chunkLoader = ((IChunkLoader)tile).getChunkLoader();
                    if (chunkLoader.canOperate()) {
                        LongSet chunks;
                        if (!forcedChunks.equals(((TileComponentChunkLoader)chunkLoader).chunkSet)) {
                            LOGGER.debug("Mismatched chunkSet for chunk loader at position: {} in {}. Correcting.", (Object)pos, (Object)worldName);
                            ((TileComponentChunkLoader)chunkLoader).chunkSet.clear();
                            ((TileComponentChunkLoader)chunkLoader).chunkSet.addAll((LongCollection)forcedChunks);
                            ((TileComponentChunkLoader)chunkLoader).markDirty();
                        }
                        if ((chunks = ((TileComponentChunkLoader)chunkLoader).getTileChunks()).isEmpty()) {
                            LOGGER.warn("Removing {} chunk tickets as they are no longer valid as this loader does not expect to have any tickets even though it is can operate. Pos: {} World: {}", (Object)ticketCount, (Object)pos, (Object)worldName);
                            this.releaseAllTickets(chunkLoader, pos, ticketHelper);
                        } else {
                            int removed = 0;
                            int added = 0;
                            LongIterator chunkIt = ((TileComponentChunkLoader)chunkLoader).chunkSet.iterator();
                            while (chunkIt.hasNext()) {
                                long chunkPos = chunkIt.nextLong();
                                if (chunks.contains(chunkPos)) continue;
                                ticketHelper.removeTicket(pos, chunkPos, false);
                                chunkIt.remove();
                                ++removed;
                            }
                            LongIterator longIterator = chunks.iterator();
                            while (longIterator.hasNext()) {
                                long chunkPos = (Long)longIterator.next();
                                if (!((TileComponentChunkLoader)chunkLoader).chunkSet.add(chunkPos)) continue;
                                ForgeChunkManager.forceChunk((ServerWorld)world, (String)"mekanism", (BlockPos)pos, (int)((int)chunkPos), (int)((int)(chunkPos >> 32)), (boolean)true, (boolean)false);
                                ++added;
                            }
                            ((TileComponentChunkLoader)chunkLoader).hasRegistered = true;
                            ((TileComponentChunkLoader)chunkLoader).prevWorld = world;
                            ((TileComponentChunkLoader)chunkLoader).prevPos = pos;
                            if (removed == 0 && added == 0) {
                                LOGGER.debug("Tickets for position: {} in {}, successfully validated.", (Object)pos, (Object)worldName);
                            } else {
                                ((TileComponentChunkLoader)chunkLoader).markDirty();
                                LOGGER.info("Removed {} no longer valid chunk tickets, and added {} newly valid chunk tickets. Pos: {} World: {}", (Object)removed, (Object)added, (Object)pos, (Object)worldName);
                            }
                        }
                    } else {
                        LOGGER.info("Removing {} chunk tickets as they are no longer valid as this loader cannot operate. Pos: {} World: {}", (Object)ticketCount, (Object)pos, (Object)worldName);
                        this.releaseAllTickets(chunkLoader, pos, ticketHelper);
                    }
                    ((TileComponentChunkLoader)chunkLoader).isFirstTick = false;
                    continue;
                }
                LOGGER.warn("Block at {}, in {}, is not a valid chunk loader. Removing {} chunk tickets.", (Object)pos, (Object)worldName, (Object)ticketCount);
                ticketHelper.removeAllTickets(pos);
            }
        }

        private void releaseAllTickets(TileComponentChunkLoader<?> chunkLoader, BlockPos pos, ForgeChunkManager.TicketHelper ticketHelper) {
            ticketHelper.removeAllTickets(pos);
            ((TileComponentChunkLoader)chunkLoader).chunkSet.clear();
            ((TileComponentChunkLoader)chunkLoader).hasRegistered = false;
            ((TileComponentChunkLoader)chunkLoader).prevWorld = null;
            ((TileComponentChunkLoader)chunkLoader).markDirty();
        }
    }
}

