/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.ISecurityContainer;
import mekanism.common.inventory.slot.SecurityInventorySlot;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityData;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.network.PacketSecurityUpdate;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntitySecurityDesk
extends TileEntityMekanism
implements IBoundingBlock {
    public UUID ownerUUID;
    public String clientOwner;
    private SecurityInventorySlot unlockSlot;
    private SecurityInventorySlot lockSlot;

    public TileEntitySecurityDesk() {
        super(MekanismBlocks.SECURITY_DESK);
        this.addDisabledCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.unlockSlot = SecurityInventorySlot.unlock(() -> this.ownerUUID, this, 146, 18);
        builder.addSlot(this.unlockSlot);
        this.lockSlot = SecurityInventorySlot.lock(this, 146, 97);
        builder.addSlot(this.lockSlot);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        SecurityFrequency frequency = this.getFreq();
        if (this.ownerUUID != null && frequency != null) {
            this.unlockSlot.unlock(this.ownerUUID);
            this.lockSlot.lock(this.ownerUUID, frequency);
        }
    }

    public void toggleOverride() {
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null) {
            frequency.setOverridden(!frequency.isOverridden());
            this.markDirty(false);
            Mekanism.packetHandler.sendToAll(new PacketSecurityUpdate(frequency.getOwner(), new SecurityData(frequency)));
            this.validateAccess();
        }
    }

    private void validateAccess() {
        MinecraftServer server;
        if (this.func_145830_o() && (server = this.getWorldNN().func_73046_m()) != null) {
            for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
                if (!(player.field_71070_bA instanceof ISecurityContainer) || SecurityUtils.canAccess((PlayerEntity)player, ((ISecurityContainer)player.field_71070_bA).getSecurityObject())) continue;
                player.func_71053_j();
            }
        }
    }

    public void removeTrusted(int index) {
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null) {
            frequency.removeTrusted(index);
            this.markDirty(false);
        }
    }

    public void setSecurityDeskMode(SecurityMode mode) {
        SecurityMode old;
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null && (old = frequency.getSecurityMode()) != mode) {
            frequency.setSecurityMode(mode);
            this.markDirty(false);
            Mekanism.packetHandler.sendToAll(new PacketSecurityUpdate(frequency.getOwner(), new SecurityData(frequency)));
            if (old == SecurityMode.PUBLIC || old == SecurityMode.TRUSTED && mode == SecurityMode.PRIVATE) {
                this.validateAccess();
            }
        }
    }

    public void addTrusted(String name) {
        GameProfile profile;
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null && (profile = ServerLifecycleHooks.getCurrentServer().func_152358_ax().func_152655_a(name)) != null) {
            frequency.addTrusted(profile.getId(), profile.getName());
            this.markDirty(false);
        }
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        NBTUtils.setUUIDIfPresent(nbtTags, "owner", uuid -> {
            this.ownerUUID = uuid;
        });
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.ownerUUID != null) {
            nbtTags.func_186854_a("owner", this.ownerUUID);
        }
        return nbtTags;
    }

    @Override
    public void onPlace() {
        WorldUtils.makeBoundingBlock((IWorld)this.func_145831_w(), this.func_174877_v().func_177984_a(), this.func_174877_v());
    }

    @Override
    public void onBreak(BlockState oldState) {
        World world = this.func_145831_w();
        if (world != null) {
            world.func_217377_a(this.func_174877_v().func_177984_a(), false);
            world.func_217377_a(this.func_174877_v(), false);
        }
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        if (this.ownerUUID != null) {
            updateTag.func_186854_a("owner", this.ownerUUID);
            updateTag.func_74778_a("ownerName", MekanismUtils.getLastKnownUsername(this.ownerUUID));
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setUUIDIfPresent(tag, "owner", uuid -> {
            this.ownerUUID = uuid;
        });
        NBTUtils.setStringIfPresent(tag, "ownerName", uuid -> {
            this.clientOwner = uuid;
        });
    }

    public SecurityFrequency getFreq() {
        return (SecurityFrequency)this.getFrequency(FrequencyType.SECURITY);
    }
}

