/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Upgrade;
import mekanism.common.Mekanism;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class TileEntityBoundingBlock
extends TileEntityUpdateable
implements IUpgradeTile {
    private BlockPos mainPos = BlockPos.field_177992_a;
    public boolean receivedCoords;
    private int currentRedstoneLevel;

    public TileEntityBoundingBlock() {
        this(MekanismTileEntityTypes.BOUNDING_BLOCK.getTileEntityType());
    }

    public TileEntityBoundingBlock(TileEntityType<TileEntityBoundingBlock> type) {
        super(type);
    }

    public void setMainLocation(BlockPos pos) {
        boolean bl = this.receivedCoords = pos != null;
        if (!this.isRemote()) {
            this.mainPos = pos;
            this.sendUpdatePacket();
        }
    }

    public BlockPos getMainPos() {
        if (this.mainPos == null) {
            this.mainPos = BlockPos.field_177992_a;
        }
        return this.mainPos;
    }

    @Nullable
    public TileEntity getMainTile() {
        return this.receivedCoords ? WorldUtils.getTileEntity((IBlockReader)this.field_145850_b, this.getMainPos()) : null;
    }

    protected IBoundingBlock getInv() {
        TileEntity tile = this.getMainTile();
        if (tile != null && !(tile instanceof IBoundingBlock)) {
            Mekanism.logger.error("Found tile {} instead of an IBoundingBlock, at {}. Multiblock cannot function", (Object)tile, (Object)this.getMainPos());
            return null;
        }
        return (IBoundingBlock)tile;
    }

    public void onNeighborChange(BlockState state) {
        int power;
        TileEntity tile = this.getMainTile();
        if (tile instanceof TileEntityMekanism && this.currentRedstoneLevel != (power = this.field_145850_b.func_175687_A(this.func_174877_v()))) {
            if (power > 0) {
                this.onPower();
            } else {
                this.onNoPower();
            }
            this.currentRedstoneLevel = power;
            ((TileEntityMekanism)tile).sendUpdatePacket(this);
        }
    }

    public void onPower() {
    }

    public void onNoPower() {
    }

    @Override
    public boolean supportsUpgrades() {
        IBoundingBlock inv = this.getInv();
        return inv instanceof IUpgradeTile && ((IUpgradeTile)((Object)inv)).supportsUpgrades();
    }

    @Override
    public TileComponentUpgrade getComponent() {
        IUpgradeTile upgradeTile;
        IBoundingBlock inv = this.getInv();
        if (inv instanceof IUpgradeTile && (upgradeTile = (IUpgradeTile)((Object)inv)).supportsUpgrades()) {
            return upgradeTile.getComponent();
        }
        return null;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgradeType) {
        IUpgradeTile upgradeTile;
        IBoundingBlock inv = this.getInv();
        if (inv instanceof IUpgradeTile && (upgradeTile = (IUpgradeTile)((Object)inv)).supportsUpgrades()) {
            upgradeTile.recalculateUpgrades(upgradeType);
        }
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        NBTUtils.setBlockPosIfPresent(nbtTags, "main", pos -> {
            this.mainPos = pos;
        });
        this.currentRedstoneLevel = nbtTags.func_74762_e("redstone");
        this.receivedCoords = nbtTags.func_74767_n("receivedCoords");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_218657_a("main", (INBT)NBTUtil.func_186859_a((BlockPos)this.getMainPos()));
        nbtTags.func_74768_a("redstone", this.currentRedstoneLevel);
        nbtTags.func_74757_a("receivedCoords", this.receivedCoords);
        return nbtTags;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_218657_a("main", (INBT)NBTUtil.func_186859_a((BlockPos)this.getMainPos()));
        updateTag.func_74768_a("redstone", this.currentRedstoneLevel);
        updateTag.func_74757_a("receivedCoords", this.receivedCoords);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setBlockPosIfPresent(tag, "main", pos -> {
            this.mainPos = pos;
        });
        this.currentRedstoneLevel = tag.func_74762_e("redstone");
        this.receivedCoords = tag.func_74767_n("receivedCoords");
    }
}

