/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.lib.security.SecurityMode;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSecurityMode {
    private final Hand currentHand;
    private final SecurityMode value;

    public PacketSecurityMode(Hand hand, SecurityMode control) {
        this.currentHand = hand;
        this.value = control;
    }

    public static void handle(PacketSecurityMode message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ItemStack stack;
            ServerPlayerEntity player = ctx.getSender();
            if (player != null && (stack = player.func_184586_b(message.currentHand)).func_77973_b() instanceof ISecurityItem) {
                ((ISecurityItem)stack.func_77973_b()).setSecurity(stack, message.value);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketSecurityMode pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.currentHand);
        buf.func_179249_a((Enum)pkt.value);
    }

    public static PacketSecurityMode decode(PacketBuffer buf) {
        return new PacketSecurityMode((Hand)buf.func_179257_a(Hand.class), (SecurityMode)buf.func_179257_a(SecurityMode.class));
    }
}

