/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.tile;

import javax.annotation.Nonnull;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.ISecurityObject;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.tile.qio.TileEntityQIODashboard;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockReader;

public class QIODashboardContainer
extends QIOItemViewerContainer {
    private final TileEntityQIODashboard tile;

    private QIODashboardContainer(int id, PlayerInventory inv, TileEntityQIODashboard tile, boolean remote) {
        super(MekanismContainerTypes.QIO_DASHBOARD, id, inv, remote);
        this.tile = tile;
        if (tile != null) {
            tile.addContainerTrackers(this);
        }
        this.addSlotsAndOpen();
    }

    public QIODashboardContainer(int id, PlayerInventory inv, TileEntityQIODashboard tile) {
        this(id, inv, tile, false);
    }

    public QIODashboardContainer(int id, PlayerInventory inv, PacketBuffer buf) {
        this(id, inv, MekanismTileContainer.getTileFromBuf(buf, TileEntityQIODashboard.class), true);
    }

    @Override
    public QIODashboardContainer recreate() {
        QIODashboardContainer container = new QIODashboardContainer(this.field_75152_c, this.inv, this.tile);
        this.sync(container);
        return container;
    }

    @Override
    public QIOFrequency getFrequency() {
        return (QIOFrequency)this.tile.getFrequency(FrequencyType.QIO);
    }

    @Override
    protected void openInventory(@Nonnull PlayerInventory inv) {
        super.openInventory(inv);
        if (this.tile != null) {
            this.tile.open(inv.field_70458_d);
        }
    }

    @Override
    protected void closeInventory(PlayerEntity player) {
        super.closeInventory(player);
        if (this.tile != null) {
            this.tile.close(player);
        }
    }

    @Override
    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        if (this.tile == null) {
            return true;
        }
        return this.tile.hasGui() && !this.tile.func_145837_r() && WorldUtils.isBlockLoaded((IBlockReader)this.tile.func_145831_w(), this.tile.func_174877_v());
    }

    public TileEntityQIODashboard getTileEntity() {
        return this.tile;
    }

    @Override
    public ISecurityObject getSecurityObject() {
        return this.tile;
    }
}

