/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.WorldUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.items.IItemHandler;

public class InventoryNetwork
extends DynamicNetwork<IItemHandler, InventoryNetwork, LogisticalTransporterBase> {
    public InventoryNetwork(UUID networkID) {
        super(networkID);
    }

    public InventoryNetwork(Collection<InventoryNetwork> networks) {
        this(UUID.randomUUID());
        this.adoptAllAndRegister(networks);
    }

    public List<AcceptorData> calculateAcceptors(TransitRequest request, TransporterStack stack, Long2ObjectMap<IChunk> chunkMap) {
        ArrayList<AcceptorData> toReturn = new ArrayList<AcceptorData>();
        for (Map.Entry entry : this.acceptorCache.getAcceptorEntrySet()) {
            TileEntity acceptor;
            BlockPos pos = entry.getKey();
            if (pos.equals((Object)stack.homeLocation) || (acceptor = WorldUtils.getTileEntity((IWorld)this.getWorld(), chunkMap, pos)) == null) continue;
            AcceptorData data = null;
            Coord4D position = Coord4D.get(acceptor);
            for (Map.Entry acceptorEntry : entry.getValue().entrySet()) {
                TransitRequest.TransitResponse response;
                EnumColor configColor;
                ISideConfiguration config;
                Optional handler = acceptorEntry.getValue().resolve();
                if (!handler.isPresent()) continue;
                Direction side = acceptorEntry.getKey();
                if (acceptor instanceof ISideConfiguration && (config = (ISideConfiguration)acceptor).getEjector().hasStrictInput() && (configColor = config.getEjector().getInputColor(RelativeSide.fromDirections(config.getOrientation(), side))) != null && configColor != stack.color || (response = TransporterManager.getPredictedInsert(position, side, (IItemHandler)handler.get(), request)).isEmpty()) continue;
                Direction opposite = side.func_176734_d();
                if (data == null) {
                    data = new AcceptorData(pos, response, opposite);
                    toReturn.add(data);
                    continue;
                }
                data.sides.add(opposite);
            }
        }
        return toReturn;
    }

    @Override
    public void commit() {
        super.commit();
        PathfinderCache.onChanged(this);
    }

    @Override
    public void deregister() {
        super.deregister();
        PathfinderCache.onChanged(this);
    }

    public String toString() {
        return "[InventoryNetwork] " + this.transmitters.size() + " transmitters, " + this.getAcceptorCount() + " acceptors.";
    }

    @Override
    public ITextComponent getTextComponent() {
        return MekanismLang.NETWORK_DESCRIPTION.translate(MekanismLang.INVENTORY_NETWORK, this.transmitters.size(), this.getAcceptorCount());
    }

    public static class AcceptorData {
        private final BlockPos location;
        private final TransitRequest.TransitResponse response;
        private final Set<Direction> sides;

        protected AcceptorData(BlockPos pos, TransitRequest.TransitResponse ret, Direction side) {
            this.location = pos;
            this.response = ret;
            this.sides = EnumSet.of(side);
        }

        public TransitRequest.TransitResponse getResponse() {
            return this.response;
        }

        public BlockPos getLocation() {
            return this.location;
        }

        public Set<Direction> getSides() {
            return this.sides;
        }
    }
}

