/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.heat.HeatAPI;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.MathUtils;
import mekanism.common.capabilities.chemical.multiblock.MultiblockChemicalTankBuilder;
import mekanism.common.capabilities.fluid.MultiblockFluidTank;
import mekanism.common.capabilities.heat.MultiblockHeatCapacitor;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class BoilerMultiblockData
extends MultiblockData
implements IValveHandler {
    public static final Object2BooleanMap<UUID> hotMap = new Object2BooleanOpenHashMap();
    public static final double CASING_HEAT_CAPACITY = 50.0;
    public static final double CASING_INVERSE_INSULATION_COEFFICIENT = 100000.0;
    public static final double CASING_INVERSE_CONDUCTION_COEFFICIENT = 1.0;
    public static final int WATER_PER_VOLUME = 16000;
    public static final long STEAM_PER_VOLUME = 160000L;
    public static final int SUPERHEATED_COOLANT_PER_VOLUME = 256000;
    public static final int COOLED_COOLANT_PER_VOLUME = 256000;
    public static final double COOLANT_COOLING_EFFICIENCY = 0.4;
    @ContainerSync
    public IGasTank superheatedCoolantTank;
    @ContainerSync
    public IGasTank cooledCoolantTank;
    @ContainerSync
    public MultiblockFluidTank<BoilerMultiblockData> waterTank;
    @ContainerSync
    public IGasTank steamTank;
    @ContainerSync
    public MultiblockHeatCapacitor<BoilerMultiblockData> heatCapacitor;
    @ContainerSync
    public double lastEnvironmentLoss;
    @ContainerSync
    public int lastBoilRate;
    @ContainerSync
    public int lastMaxBoil;
    public boolean clientHot;
    @ContainerSync
    public int superheatingElements;
    @ContainerSync(setter="setWaterVolume")
    private int waterVolume;
    @ContainerSync(setter="setSteamVolume")
    private int steamVolume;
    private int waterTankCapacity;
    private long superheatedCoolantCapacity;
    private long steamTankCapacity;
    private long cooledCoolantCapacity;
    public BlockPos upperRenderLocation;
    public float prevWaterScale;
    public float prevSteamScale;

    public BoilerMultiblockData(TileEntityBoilerCasing tile) {
        super(tile);
        this.superheatedCoolantTank = MultiblockChemicalTankBuilder.GAS.create(this, tile, this::getSuperheatedCoolantTankCapacity, (stack, automationType) -> automationType != AutomationType.EXTERNAL, (stack, automationType) -> automationType != AutomationType.EXTERNAL || this.isFormed(), gas -> gas.has(GasAttributes.HeatedCoolant.class));
        this.waterTank = MultiblockFluidTank.input(this, tile, this::getWaterTankCapacity, fluid -> fluid.getFluid().func_207185_a((ITag)FluidTags.field_206959_a));
        this.fluidTanks.add(this.waterTank);
        this.steamTank = MultiblockChemicalTankBuilder.GAS.create(this, tile, this::getSteamTankCapacity, (stack, automationType) -> automationType != AutomationType.EXTERNAL || this.isFormed(), (stack, automationType) -> automationType != AutomationType.EXTERNAL, gas -> gas == MekanismGases.STEAM.getChemical());
        this.cooledCoolantTank = MultiblockChemicalTankBuilder.GAS.create(this, tile, this::getCooledCoolantTankCapacity, (stack, automationType) -> automationType != AutomationType.EXTERNAL || this.isFormed(), (stack, automationType) -> automationType != AutomationType.EXTERNAL, gas -> gas.has(GasAttributes.CooledCoolant.class));
        this.gasTanks.addAll(Arrays.asList(this.steamTank, this.superheatedCoolantTank, this.cooledCoolantTank));
        this.heatCapacitor = MultiblockHeatCapacitor.create(this, tile, 50.0, () -> 1.0, () -> 100000.0);
        this.heatCapacitors.add(this.heatCapacitor);
    }

    @Override
    public void onCreated(World world) {
        super.onCreated(world);
        this.heatCapacitor.setHeatCapacity(50.0 * (double)this.locations.size(), true);
    }

    @Override
    public boolean tick(World world) {
        float steamScale;
        GasAttributes.HeatedCoolant coolantType;
        boolean newHot;
        boolean needsPacket = super.tick(world);
        boolean bl = newHot = this.getTotalTemperature() >= HeatUtils.BASE_BOIL_TEMP - 0.01;
        if (newHot != this.clientHot) {
            needsPacket = true;
            this.clientHot = newHot;
            hotMap.put((Object)this.inventoryID, this.clientHot);
        }
        HeatAPI.HeatTransfer transfer = this.simulate();
        this.updateHeatCapacitors(null);
        this.lastEnvironmentLoss = transfer.getEnvironmentTransfer();
        if (!this.superheatedCoolantTank.isEmpty() && (coolantType = ((GasStack)this.superheatedCoolantTank.getStack()).get(GasAttributes.HeatedCoolant.class)) != null) {
            long toCool = Math.round(0.4 * (double)this.superheatedCoolantTank.getStored());
            toCool = MathUtils.clampToLong((double)toCool * (1.0 - this.heatCapacitor.getTemperature() / 100000.0));
            GasStack cooledCoolant = coolantType.getCooledGas().getStack(toCool);
            if ((toCool = Math.min(toCool, toCool - this.cooledCoolantTank.insert(cooledCoolant, Action.EXECUTE, AutomationType.INTERNAL).getAmount())) > 0L) {
                double heatEnergy = (double)toCool * coolantType.getThermalEnthalpy();
                this.heatCapacitor.handleHeat(heatEnergy);
                this.superheatedCoolantTank.shrinkStack(toCool, Action.EXECUTE);
            }
        }
        if (this.getTotalTemperature() >= HeatUtils.BASE_BOIL_TEMP && !this.waterTank.isEmpty()) {
            double heatAvailable = this.getHeatAvailable();
            this.lastMaxBoil = (int)Math.floor(HeatUtils.getSteamEnergyEfficiency() * heatAvailable / HeatUtils.getWaterThermalEnthalpy());
            int amountToBoil = Math.min(this.lastMaxBoil, this.waterTank.getFluidAmount());
            amountToBoil = Math.min(amountToBoil, MathUtils.clampToInt(this.steamTank.getNeeded()));
            if (!this.waterTank.isEmpty()) {
                this.waterTank.shrinkStack(amountToBoil, Action.EXECUTE);
            }
            if (this.steamTank.isEmpty()) {
                this.steamTank.setStack(MekanismGases.STEAM.getStack(amountToBoil));
            } else {
                this.steamTank.growStack(amountToBoil, Action.EXECUTE);
            }
            this.handleHeat((double)(-amountToBoil) * HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency());
            this.lastBoilRate = amountToBoil;
        } else {
            this.lastBoilRate = 0;
            this.lastMaxBoil = 0;
        }
        float waterScale = MekanismUtils.getScale(this.prevWaterScale, this.waterTank);
        if (waterScale != this.prevWaterScale) {
            needsPacket = true;
            this.prevWaterScale = waterScale;
        }
        if ((steamScale = MekanismUtils.getScale(this.prevSteamScale, this.steamTank)) != this.prevSteamScale) {
            needsPacket = true;
            this.prevSteamScale = steamScale;
        }
        return needsPacket;
    }

    @Override
    public void readUpdateTag(CompoundNBT tag) {
        super.readUpdateTag(tag);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            this.prevWaterScale = scale;
        });
        NBTUtils.setFloatIfPresent(tag, "scaleAlt", scale -> {
            this.prevSteamScale = scale;
        });
        NBTUtils.setIntIfPresent(tag, "volume", this::setWaterVolume);
        NBTUtils.setIntIfPresent(tag, "lowerVolume", this::setSteamVolume);
        NBTUtils.setFluidStackIfPresent(tag, "fluid", value -> this.waterTank.setStack((FluidStack)value));
        NBTUtils.setGasStackIfPresent(tag, "gas", value -> this.steamTank.setStack(value));
        NBTUtils.setBlockPosIfPresent(tag, "renderY", value -> {
            this.upperRenderLocation = value;
        });
        NBTUtils.setBooleanIfPresent(tag, "hot", value -> {
            this.clientHot = value;
        });
        this.readValves(tag);
    }

    @Override
    public void writeUpdateTag(CompoundNBT tag) {
        super.writeUpdateTag(tag);
        tag.func_74776_a("scale", this.prevWaterScale);
        tag.func_74776_a("scaleAlt", this.prevSteamScale);
        tag.func_74768_a("volume", this.getWaterVolume());
        tag.func_74768_a("lowerVolume", this.getSteamVolume());
        tag.func_218657_a("fluid", (INBT)this.waterTank.getFluid().writeToNBT(new CompoundNBT()));
        tag.func_218657_a("gas", (INBT)((GasStack)this.steamTank.getStack()).write(new CompoundNBT()));
        tag.func_218657_a("renderY", (INBT)NBTUtil.func_186859_a((BlockPos)this.upperRenderLocation));
        tag.func_74757_a("hot", this.clientHot);
        this.writeValves(tag);
    }

    @Override
    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.waterTank.getFluidAmount(), this.waterTank.getCapacity());
    }

    public double getHeatAvailable() {
        double heatAvailable = (this.heatCapacitor.getTemperature() - HeatUtils.BASE_BOIL_TEMP) * (this.heatCapacitor.getHeatCapacity() * MekanismConfig.general.boilerWaterConductivity.get());
        return Math.min(heatAvailable, MekanismConfig.general.superheatingHeatTransfer.get() * (double)this.superheatingElements);
    }

    @Override
    @Nonnull
    public HeatAPI.HeatTransfer simulate() {
        double invConduction = 110001.0;
        double heatToTransfer = (this.heatCapacitor.getTemperature() - 300.0) / invConduction;
        this.heatCapacitor.handleHeat(-heatToTransfer * this.heatCapacitor.getHeatCapacity());
        return new HeatAPI.HeatTransfer(0.0, heatToTransfer);
    }

    public int getWaterTankCapacity() {
        return this.waterTankCapacity;
    }

    public long getSteamTankCapacity() {
        return this.steamTankCapacity;
    }

    public long getSuperheatedCoolantTankCapacity() {
        return this.superheatedCoolantCapacity;
    }

    public long getCooledCoolantTankCapacity() {
        return this.cooledCoolantCapacity;
    }

    public int getWaterVolume() {
        return this.waterVolume;
    }

    public void setWaterVolume(int volume) {
        this.waterVolume = volume;
        this.waterTankCapacity = this.getWaterVolume() * 16000;
        this.superheatedCoolantCapacity = (long)this.getWaterVolume() * 256000L;
    }

    public int getSteamVolume() {
        return this.steamVolume;
    }

    public void setSteamVolume(int volume) {
        this.steamVolume = volume;
        this.steamTankCapacity = (long)this.getSteamVolume() * 160000L;
        this.cooledCoolantCapacity = (long)this.getSteamVolume() * 256000L;
    }
}

