/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import javax.annotation.Nonnull;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.custom.GuiMekaSuitHelmetOptions;
import mekanism.client.gui.element.custom.GuiModuleScreen;
import mekanism.client.gui.element.scroll.GuiModuleScrollList;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.Module;
import mekanism.common.inventory.container.ModuleTweakerContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.network.PacketUpdateInventorySlot;
import mekanism.common.registries.MekanismItems;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class GuiModuleTweaker
extends GuiMekanism<ModuleTweakerContainer> {
    private GuiModuleScrollList scrollList;
    private GuiModuleScreen moduleScreen;
    private TranslationButton optionsButton;
    private int selected = -1;

    public GuiModuleTweaker(ModuleTweakerContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_146999_f = 248;
        this.field_147000_g += 20;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.moduleScreen = new GuiModuleScreen(this, 138, 20, stack -> {
            int slotId = ((Slot)((ModuleTweakerContainer)this.field_147002_h).field_75151_b.get(this.selected)).getSlotIndex();
            Mekanism.packetHandler.sendToServer(new PacketUpdateInventorySlot((ItemStack)stack, slotId));
            this.field_213127_e.field_70458_d.field_71071_by.func_70299_a(slotId, stack);
        });
        this.func_230480_a_(this.moduleScreen);
        this.scrollList = new GuiModuleScrollList((IGuiWrapper)this, 30, 20, 108, 116, () -> this.getStack(this.selected), this::onModuleSelected);
        this.func_230480_a_(this.scrollList);
        this.func_230480_a_(new GuiElementHolder(this, 30, 136, 108, 18));
        this.optionsButton = new TranslationButton(this, this.field_147003_i + 31, this.field_147009_r + 137, 106, 16, MekanismLang.BUTTON_OPTIONS, this::openOptions);
        this.func_230480_a_(this.optionsButton);
        this.optionsButton.field_230693_o_ = false;
        int size = ((ModuleTweakerContainer)this.field_147002_h).field_75151_b.size();
        for (int i = 0; i < size; ++i) {
            Slot slot = (Slot)((ModuleTweakerContainer)this.field_147002_h).field_75151_b.get(i);
            int index = i;
            if (this.selected == -1 && this.isValidItem(index)) {
                this.select(index);
            }
            this.func_230480_a_(new GuiSlot(SlotType.NORMAL, this, slot.field_75223_e - 1, slot.field_75221_f - 1).click((e, x, y) -> this.select(index)).overlayColor(this.isValidItem(index) ? null : () -> -869059789).with(() -> index == this.selected ? SlotOverlay.SELECT : null));
        }
    }

    private void onModuleSelected(Module module) {
        this.moduleScreen.setModule(module);
    }

    private void openOptions() {
        this.addWindow(new GuiMekaSuitHelmetOptions(this, this.getWidth() / 2 - 70, this.getHeight() / 2 - 45));
    }

    @Override
    public boolean func_231046_a_(int key, int i, int j) {
        if (super.func_231046_a_(key, i, j)) {
            return true;
        }
        if (this.selected != -1) {
            int curIndex = -1;
            IntArrayList selectable = new IntArrayList();
            for (int index = 0; index < ((ModuleTweakerContainer)this.field_147002_h).field_75151_b.size(); ++index) {
                if (!this.isValidItem(index)) continue;
                selectable.add(index);
                if (index != this.selected) continue;
                curIndex = selectable.size() - 1;
            }
            if (key == 265 || key == 263) {
                curIndex = curIndex == 0 ? curIndex + selectable.size() - 1 : curIndex - 1;
                this.select(selectable.getInt(curIndex % selectable.size()));
                return true;
            }
            if (key == 264 || key == 262) {
                this.select(selectable.getInt((curIndex + 1) % selectable.size()));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.moduleScreen.func_231000_a__(mouseX, mouseY);
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawTitleText(matrix, (ITextComponent)MekanismLang.MODULE_TWEAKER.translate(new Object[0]), this.field_238743_q_);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    private void select(int index) {
        if (this.isValidItem(index)) {
            this.selected = index;
            ItemStack stack = this.getStack(index);
            this.scrollList.updateList(stack, true);
            this.optionsButton.field_230693_o_ = stack.func_77973_b() == MekanismItems.MEKASUIT_HELMET.get();
        }
    }

    private boolean isValidItem(int index) {
        return ModuleTweakerContainer.isTweakableItem(this.getStack(index));
    }

    private ItemStack getStack(int index) {
        if (index == -1) {
            return ItemStack.field_190927_a;
        }
        return ((Slot)((ModuleTweakerContainer)this.field_147002_h).field_75151_b.get(index)).func_75211_c();
    }
}

