/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.chemical;

import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ItemStackChemicalToItemStackRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>>
extends MekanismRecipe
implements BiPredicate<ItemStack, STACK> {
    private final ItemStackIngredient itemInput;
    private final INGREDIENT chemicalInput;
    private final ItemStack output;

    public ItemStackChemicalToItemStackRecipe(ResourceLocation id, ItemStackIngredient itemInput, INGREDIENT chemicalInput, ItemStack output) {
        super(id);
        this.itemInput = itemInput;
        this.chemicalInput = chemicalInput;
        this.output = output;
    }

    public ItemStackIngredient getItemInput() {
        return this.itemInput;
    }

    public INGREDIENT getChemicalInput() {
        return this.chemicalInput;
    }

    @Contract(value="_, _ -> new", pure=true)
    public ItemStack getOutput(ItemStack inputItem, STACK inputChemical) {
        return this.output.func_77946_l();
    }

    @Override
    @Nonnull
    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    @Override
    public boolean test(ItemStack itemStack, STACK gasStack) {
        return this.itemInput.test(itemStack) && this.chemicalInput.test(gasStack);
    }

    public @NonNull List<@NonNull ItemStack> getOutputDefinition() {
        return this.output.func_190926_b() ? Collections.emptyList() : Collections.singletonList(this.output);
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.itemInput.write(buffer);
        this.chemicalInput.write(buffer);
        buffer.func_150788_a(this.output);
    }
}

