/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class CombinerRecipe
extends MekanismRecipe
implements BiPredicate<ItemStack, ItemStack> {
    private final ItemStackIngredient mainInput;
    private final ItemStackIngredient extraInput;
    private final ItemStack output;

    public CombinerRecipe(ResourceLocation id, ItemStackIngredient mainInput, ItemStackIngredient extraInput, ItemStack output) {
        super(id);
        this.mainInput = mainInput;
        this.extraInput = extraInput;
        this.output = output.func_77946_l();
    }

    @Override
    public boolean test(@Nonnull ItemStack input, @Nonnull ItemStack extra) {
        return this.mainInput.test(input) && this.extraInput.test(extra);
    }

    public ItemStackIngredient getMainInput() {
        return this.mainInput;
    }

    public ItemStackIngredient getExtraInput() {
        return this.extraInput;
    }

    @Contract(value="_, _ -> new", pure=true)
    public ItemStack getOutput(@Nonnull ItemStack input, @Nonnull ItemStack extra) {
        return this.output.func_77946_l();
    }

    @Override
    @Nonnull
    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public List<ItemStack> getOutputDefinition() {
        return this.output.func_190926_b() ? Collections.emptyList() : Collections.singletonList(this.output);
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.mainInput.write(buffer);
        this.extraInput.write(buffer);
        buffer.func_150788_a(this.output);
    }
}

