/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.function.Supplier;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class RouterSettingsMessage {
    private final boolean ecoMode;
    private final RouterRedstoneBehaviour redstoneBehaviour;
    private final TileEntityItemRouter.EnergyDirection energyDirection;
    private final BlockPos pos;

    public RouterSettingsMessage(TileEntityItemRouter router) {
        this.pos = router.func_174877_v();
        this.redstoneBehaviour = router.getRedstoneBehaviour();
        this.ecoMode = router.getEcoMode();
        this.energyDirection = router.getEnergyDirection();
    }

    RouterSettingsMessage(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.redstoneBehaviour = RouterRedstoneBehaviour.values()[buffer.readByte()];
        this.ecoMode = buffer.readBoolean();
        this.energyDirection = (TileEntityItemRouter.EnergyDirection)buffer.func_179257_a(TileEntityItemRouter.EnergyDirection.class);
    }

    public void toBytes(PacketBuffer byteBuf) {
        byteBuf.func_179255_a(this.pos);
        byteBuf.writeByte(this.redstoneBehaviour.ordinal());
        byteBuf.writeBoolean(this.ecoMode);
        byteBuf.func_179249_a((Enum)this.energyDirection);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World w = ((NetworkEvent.Context)ctx.get()).getSender() == null ? ClientUtil.theClientWorld() : ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q();
            TileEntityItemRouter.getRouterAt((IBlockReader)w, this.pos).ifPresent(router -> {
                router.setRedstoneBehaviour(this.redstoneBehaviour);
                router.setEcoMode(this.ecoMode);
                router.setEnergyDirection(this.energyDirection);
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

