/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.util.BeamData;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class ItemBeamMessage {
    private final BlockPos pos1;
    private final List<BeamData> beams;

    public ItemBeamMessage(TileEntity te, List<BeamData> beams) {
        this.pos1 = te.func_174877_v();
        this.beams = beams;
    }

    public ItemBeamMessage(PacketBuffer buf) {
        this.pos1 = buf.func_179259_c();
        ImmutableList.Builder builder = ImmutableList.builder();
        int n = buf.func_150792_a();
        for (int i = 0; i < n; ++i) {
            builder.add((Object)new BeamData(buf, this.pos1));
        }
        this.beams = builder.build();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos1);
        buf.func_150787_b(this.beams.size());
        this.beams.forEach(beam -> beam.toBytes(buf, this.pos1));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> TileEntityItemRouter.getRouterAt((IBlockReader)ClientUtil.theClientWorld(), this.pos1).ifPresent(te -> this.beams.forEach(te::addItemBeam)));
        ctx.get().setPacketHandled(true);
    }
}

